import React from "react";

import { makeStyles } from "tss-react/mui";
import { Typography, Menu, MenuItem, Button } from "@mui/material";
import ArrowDropDownIcon from "@mui/icons-material/ArrowDropDown";

type ButtonTagProps = {
	text: string; //文本内容
	variant?: "text" | "contained" | "outlined"; //按钮样式
	click?: any; //点击事件
	select?: any[]; //选择按钮的下拉列表
	fontSize?: string; //按钮文字大小
	dropValue?: boolean; //选择的值
	drop?: boolean; //是否开启选择
	color?: "inherit" | "primary" | "secondary" | undefined; //按钮颜色风格
	btnStyle?: any; //按钮自定义样式类
	size?: "large" | "medium" | "small"; //按钮尺寸
	disabled?: boolean; //是否禁用
	style?: any; //按钮自定义样式
	img?: JSX.Element; //图标按钮中的图标
	selectCallBack?: (item: any, key: number) => void; //选择按钮的回调
};

const ButtonComponent = (props: ButtonTagProps) => {
	const {
		size,
		disabled,
		variant,
		color,
		img,
		btnStyle = {},
		select,
		selectCallBack,
	} = props;
	const { classes, cx } = useStyles({});
	const [anchorEl, setAnchorEl] = React.useState(null);

	const handleClick = (event: { currentTarget: React.SetStateAction<null> }) =>
		setAnchorEl(event.currentTarget);
	const defultClick = (event: { stoppropagation: () => any }) =>
		event && event.stoppropagation && event.stoppropagation();
	const handleCloseOption = (item: any, key: number) => {
		setAnchorEl(null);
		selectCallBack && selectCallBack(item, key);
	};
	const handleClose = () => setAnchorEl(null);

	return (
		<>
			<Button
				size={size || "medium"}
				variant={variant || "contained"}
				color={color || "primary"}
				disableRipple={true}
				disableFocusRipple={true}
				disabled={disabled || false}
				classes={{
					root: btnStyle.root || classes.root,
					// disabled: btnStyle.disabled || classes.disabled,
					containedSecondary:
						btnStyle.containedSecondary || classes.containedSecondary,
					outlined: btnStyle.outlined || classes.outlined,
					outlinedSecondary:
						btnStyle.outlinedSecondary || classes.outlinedSecondary,
					text: btnStyle.text || classes.text,
					textPrimary: btnStyle.textPrimary || classes.textPrimary,
					textSecondary: btnStyle.textSecondary || classes.textSecondary,
					sizeSmall: btnStyle.sizeSmall || classes.sizeSmall,
					sizeLarge: btnStyle.sizeLarge || classes.sizeLarge,
				}}
				style={{ ...props.style }}
				onClick={props.select ? handleClick : props.click || defultClick}
			>
				{img || ""}
				<Typography style={{ fontSize: props.fontSize || "14px" }}>
					{props.text}
				</Typography>
				{((props.select && props.select.length > 0) || props.drop) && (
					<ArrowDropDownIcon
						classes={{
							root: cx({
								[classes.ArrowDropDownIconRoot]: true,
								[classes.ArrowDropDownIconRootOpen]: Boolean(
									props.dropValue || anchorEl
								),
							}),
						}}
					/>
				)}
			</Button>
			<Menu
				id="simple-menu"
				anchorEl={anchorEl}
				keepMounted
				open={Boolean(anchorEl)}
				onClose={handleClose}
			>
				{select &&
					select.length > 0 &&
					select.map((item, key) => {
						return (
							<MenuItem
								key={key}
								classes={{ root: classes.menuItemRoot }}
								onClick={() => handleCloseOption(item, key)}
							>
								{item.name || ""}
							</MenuItem>
						);
					})}
			</Menu>
		</>
	);
};

const useStyles = makeStyles<{}>()((theme) => ({
	root: {
		backgroundColor: "#136EFA",
		boxShadow: "none !important",
		color: "#ffffff",
		"&:hover": { backgroundColor: "#0055D9" },
	},
	containedSecondary: {
		backgroundColor: "#D62C1F",
		boxShadow: "none !important",
		"&:hover": { backgroundColor: "#D82C1F" },
	},
	outlined: {
		backgroundColor: "#FFFFFF",
		border: "1px solid #136EFA",
		boxShadow: "none !important",
		color: "#136EFA",
		"&:hover": { backgroundColor: "rgba(19, 110, 250, 0.1)" },
	},
	outlinedSecondary: {
		border: "1px solid #D62C1F",
		color: "#D62C1F",
		"&:hover": {
			border: "1px solid #D62C1F",
			backgroundColor: "rgba(214, 44, 31, 0.1)",
		},
	},
	label: { "& p": { fontSize: "13px" } },
	text: { backgroundColor: "transparent", boxShadow: "none !important" },
	textPrimary: { color: "#136EFA", "&:hover": { backgroundColor: "#E8F1FF" } },
	textSecondary: {
		color: "#F44335",
		"&:hover": { backgroundColor: "rgba(244, 67, 53, 0.1)" },
	},
	sizeSmall: { "& p": { fontSize: "12px" } },
	sizeLarge: { "& p": { fontSize: "14px" } },
	menuItemRoot: {},
	ArrowDropDownIconRoot: {
		color: "#8A9099",
		transition: "all 0.2s !important",
		transform: "rotate(0)",
	},
	ArrowDropDownIconRootOpen: { color: "#8A9099", transform: "rotate(180deg)" },
}));

export default ButtonComponent;
