import * as React from 'react';
import Switch from '@mui/material/Switch';
import { ThemeProvider, createTheme } from "@mui/material/styles";


type IMySwitchProps = {
    value: boolean;
    onChange?: any;
    disabled?: boolean;

}

const theme = createTheme({
	components: {
		MuiSwitch: {
			styleOverrides: {
				root: {
                    height: '22px',
                    width: '40px',
                    boxSizing: 'border-box',
                    padding: '0',
				},
                switchBase:{
                    top: '4px',
                    left: '4px',
                    padding: 0,
                    '&.Mui-checked': {
                        left: '2px',
                        '& + .MuiSwitch-track': {
                            opacity: 1,
                        }
                    },
                },
                thumb: {
                    width: '14px',
                    height: '14px',
                    color: '#fff'
                },
                track: {
                    borderRadius: '11px',
                    backgroundColor: "#E6E8EB",
                    opacity: 1,
                },
			},
		},
	},
});



const MySwitch = (props: IMySwitchProps) => {
    const {value, onChange, disabled= false} = props;
    return (
        <ThemeProvider theme={theme}>
        <Switch checked={value} disabled={disabled} onChange={onChange} />
        </ThemeProvider>
    )
}

export default MySwitch;