/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 20:03:56
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-09 15:11:17
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React, { useState } from "react";
import ArrowBackIosNewIcon from "@mui/icons-material/ArrowBackIosNew";
import IconButton from "@mui/material/IconButton";

import MyPopconfirm from "@/components/mui/MyPopconfirm";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import ButtonComponent from "@/components/mui/Button";
import OperatorList from "./components/OperatorList";
import Flow from "../Project/components/Flow";
import ParameterSetting from "./components/ParameterSetting";
import { ITask } from "../Project/ProjectSubmitWork/interface";

import styles from "./index.module.css";

const radioOptions = [
	{
		value: "list",
		label: "算子列表",
	},
	{
		value: "setting",
		label: "参数设置",
	},
];

interface IProps {
	onBack?: () => void;
}

const WorkFlowEdit = (props: IProps) => {
	const { onBack } = props;
	const [templateConfigInfo, setTemplateConfigInfo] = useState<ITask[]>([]);

	const [leftContentType, setLeftContentType] = useState("list");

	const [popperTitle, setPopperTitle] = useState(
		"返回后，当前页面已填写内容将不保存，确认返回吗？"
	);
	// 返回后，当前页面已填写内容将不保存，确认返回吗？
	const [anchorEl, setAnchorEl] = useState<any>(null);
	const handleCancel = () => {
		setAnchorEl(null);
	};

	const handleShowPopper = (e: any, title: string) => {
		setPopperTitle(title);
		setAnchorEl(anchorEl ? null : e.currentTarget);
	};

	const handleConfirm = () => {
		if (popperTitle === "返回后，当前页面已填写内容将不保存，确认返回吗？") {
			onBack && onBack();
		} else {
			console.log("提交");
		}
	};

	return (
		<div className={styles.swBox}>
			<div className={styles.swHeader}>
				<div className={styles.swHeaderLeft}>
					{/* <MyPopconfirm
						title="返回后，当前页面已填写内容将不保存，确认返回吗？"
						onConfirm={onBack}
					> */}
					<IconButton
						color="primary"
						aria-label="upload picture"
						component="span"
						size="small"
						onClick={(e: any) =>
							handleShowPopper(
								e,
								"返回后，当前页面已填写内容将不保存，确认返回吗？"
							)
						}
					>
						<ArrowBackIosNewIcon
							sx={{
								color: "rgba(194, 198, 204, 1)",
								width: "12px",
								height: "12px",
							}}
						/>
					</IconButton>
					{/* </MyPopconfirm> */}
				</div>
				<div className={styles.swHeaderRight}>
					{/* <MyPopconfirm
						title="提交前请先确认参数填写无误，确认提交吗？"
						onConfirm={() => console.log(2)}
					> */}
					<ButtonComponent
						text="保存"
						click={(e: any) =>
							handleShowPopper(e, "提交前请先确认参数填写无误，确认提交吗？")
						}
					></ButtonComponent>
					{/* </MyPopconfirm> */}
				</div>
			</div>
			<div className={styles.swContent}>
				<div className={styles.swFormBox}>
					<div className={styles.radiosBox}>
						<RadioGroupOfButtonStyle
							radioOptions={radioOptions}
							value={leftContentType}
							handleRadio={setLeftContentType}
							RadiosBoxStyle={{
								height: "36px",
								padding: "3px",
							}}
							radioStyle={{
								fontSize: "16px",
								height: "30px",
							}}
						></RadioGroupOfButtonStyle>
					</div>
					{leftContentType === "list" && (
						<OperatorList
							templateConfigInfo={templateConfigInfo}
							setTemplateConfigInfo={setTemplateConfigInfo}
						/>
					)}
					{leftContentType !== "list" && (
						<ParameterSetting
							templateConfigInfo={templateConfigInfo}
							taskId={""}
						/>
					)}
				</div>
				<div className={styles.swFlowBox} id="workFlowEditRight">
					<Flow
						tasks={templateConfigInfo}
						setTasks={setTemplateConfigInfo}
						type="edit"
					/>
				</div>
			</div>
			<MyPopconfirm
				title={popperTitle}
				anchorEl={anchorEl}
				onCancel={handleCancel}
				onConfirm={handleConfirm}
			/>
		</div>
	);
};

export default WorkFlowEdit;
