import MyDialog from "@/components/mui/MyDialog";
import MyButton from "@/components/mui/MyButton";
import { DialogActions } from "@mui/material";
import style from "./index.module.css";
import { useStores } from "@/store";
import { observer } from "mobx-react-lite";
import { toJS } from "mobx";
import { useNavigate } from "react-router-dom";

const RemindBudgetDialog = observer((props: any) => {
	const navigate = useNavigate();
	const { rbOpen, rbClose, goToProjectSubmitWork, id, isParentUser, isOwner } =
		props;
	const { currentProjectStore } = useStores();
	const productId = toJS(currentProjectStore.currentProductInfo.id); // 产品ID
	const goToprojectSetting = () => {
		navigate(`/product/${productId || "cadd"}/projectSetting`, {
			state: { type: "baseInfo" },
		});
	};
	const footerRender = () => {
		return (
			<DialogActions style={{ padding: "16px 24px 16px 24px" }}>
				<MyButton
					text="继续使用"
					onClick={() => goToProjectSubmitWork(id)}
					variant="outlined"
					color="secondary"
				/>
				{isParentUser && isOwner && (
					<MyButton
						text="添加预算"
						onClick={() => goToprojectSetting()}
						variant="contained"
						style={{ marginLeft: "12px" }}
					/>
				)}
			</DialogActions>
		);
	};

	return (
		<>
			<MyDialog
				open={rbOpen}
				onClose={rbClose}
				title="项目剩余预算不足提示"
				footerRender={footerRender}
				isText={true}
			>
				<div className={style.content}>
					当前项目剩余预算不足100元，存在余额不足的风险，可能导致无法启动任务或中断运行中的任务，建议您先添加项目预算或联系项目所有者添加预算！
				</div>
			</MyDialog>
		</>
	);
});

export default RemindBudgetDialog;
