import request from "@/utils/axios/service";
import Api from "./api_manager";

type addActorenvBuildenvParams = {
  title: string,
  desc: string,
  baseEnvId: string,
  type: "BATCH" | "FLOW",
  filePaths: Array<string>,
  bashScript: string,
  computeType: string,
  publicProjectId: string,
}

// 获取公共项目
const getPublicProject = () => {
  return request({
    url: Api.API_GET_PUBLIC_PROJECT,
    method: "get",
  });
}

// 获取公共环境
const getPublicEnv = (params: {taskType: 'BATCH' | 'FLOW'}) => {
  return request({
    url: Api.API_GET_PUBLIC_ENV,
    method: "get",
    params,
  });
};

// 新增应用环境
const addActorenvBuildenv = (params: addActorenvBuildenvParams) => {
  return request({
    url: Api.API_ACTORENV_BUILDENV,
    method: "post",
    data: params,
  });
};

// 获取公共环境
const getActorenvList = (params: {
  type: 'BATCH' | 'FLOW' | '',
  page: number,
  size: number,
  title?: string,
}) => {
  return request({
    url: Api.API_ACTORENV_LIST,
    method: "get",
    params,
  });
};


export {
  getPublicEnv,
  getPublicProject,
  addActorenvBuildenv,
  getActorenvList,
};
