/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-08-02 11:43:28
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-09-02 12:01:12
 * @FilePath: /bkunyun/src/views/MenuLayout/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { Box, List } from "@mui/material";
import CurrentProject from "../Project/components/CurrentProject";
import React, { useMemo } from "react";
import { Outlet, useNavigate, useLocation } from "react-router-dom";
import style from "./index.module.css";
import { observer } from "mobx-react-lite";
import { useStores } from "@/store/index";
import classnames from "classnames";
import { toJS } from "mobx";

const MenuLayout = observer(() => {
	const { permissionStore, currentProjectStore } = useStores();
	let pathname = new URL(window.location.href).pathname;

	const navigate = useNavigate();

	const productInfo = toJS(currentProjectStore.currentProductInfo);
	const location = useLocation();

	// 在产品页面下且未选择产品时 直接跳转home页面
	if (!productInfo.name && location.pathname.slice(0, 8) === "/product") {
		navigate("/home");
	}

	const routerIcon = (id: string, isSelect: boolean) => {
		try {
			if (id === "demo") {
				return require("../../assets/project/PROJECT_SETTING.svg");
			}
			const result = require(`../../assets/project/${id}${
				isSelect ? "_BLUE" : ""
			}.svg`);
			return result || "";
		} catch (error) {
			console.log(error);
		}
	};

	// // 左侧菜单顶部是否显示当前项目组件
	// const showCurrentProject = useMemo(() => {
	// 	const noCurrentProjectRouterApp = ["userCenter", "resourceCenter"];
	// 	return noCurrentProjectRouterApp.every((item) => {
	// 		return pathname.indexOf(item) === -1;
	// 	});
	// }, [pathname]);

	const renderAsideTop = useMemo(() => {
		const noCurrentProjectRouterApp = ["userCenter", "resourceCenter"];
		if (
			noCurrentProjectRouterApp.every((item) => {
				return pathname.indexOf(item) === -1;
			})
		) {
			return <CurrentProject />;
		}
		if (pathname.indexOf("resourceCenter") !== -1) {
			return <div className={style.asideTop}>资源中心</div>;
		}
		return null;
	}, [pathname]);

	return (
		<Box className={style.container}>
			<Box className={style.aside}>
				{renderAsideTop}
				{/* {showCurrentProject && <CurrentProject />} */}
				<List
					sx={{
						paddingTop: 0,
						paddingBottom: 0,
					}}
				>
					{permissionStore.sidebarRouters.map((item, index) => {
						if (item.show) {
							return (
								<li
									key={"sidebar" + index}
									className={classnames({
										[style.listItem]: true,
										[style.active]: `/v3${item.path}` === pathname,
									})}
									style={
										`/v3${item.path}` === pathname
											? { borderLeft: "3px solid #1370ff" }
											: undefined
									}
									onClick={() => item.type === "page" && navigate(item.path)}
								>
									<img
										className={style.routerIcon}
										src={
											routerIcon(
												item.id || "",
												`/v3${item.path}` === pathname
											) || undefined
										}
										alt=""
									/>
									<span style={{ verticalAlign: "middle" }}>{item.name}</span>
								</li>
							);
						}
						return null;
					})}
				</List>
			</Box>
			<Box className={style.content}>
				<Outlet></Outlet>
			</Box>
		</Box>
	);
});

export default MenuLayout;
