/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-18 16:12:55
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-18 19:41:29
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/components/AddOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { useEffect, useState, useCallback, useMemo } from "react";
import MyInput from "@/components/mui/MyInput";
import MySelect from "@/components/mui/MySelect";
import MyButton from "@/components/mui/MyButton";
import style from "./index.module.css";
import SwitchBatchFolw from "@/views/ResourceCenter/components/SwitchBatchFolw";

import Code from "@/components/CommonComponents/Code";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import { ITask } from "@/views/Project/ProjectSubmitWork/interface";
import BatchOperatorFlow from "@/views/Project/components/Flow/components/BatchOperatorFlow";
import OperatorList from "@/views/CustomOperator/components/OperatorList";

interface IAddOperator {
	setAddOpen: (val: boolean) => void;
}

type IBuildType = "ENVIRONMENT" | "OPERATOR";

const AddEnvironment = (props: IAddOperator) => {
	const { setAddOpen } = props;

	/** 创建类型 BATCH - 批算子;  FLOW - 流算子*/
	const [taskType, setTaskType] = useState<"BATCH" | "FLOW">("BATCH");
	/** 创建类型 BATCH - 批算子;  FLOW - 流算子*/
	const [batchBuildType, setBatchBuildType] =
		useState<IBuildType>("ENVIRONMENT");
	/** 算子数组 */
	const [operatorList, setOperatorList] = useState<ITask[]>([]);
	/** 流程编排 算子是否选中 */
	const [inputActive, setInputActive] = useState(false);

	const [code, setCode] = useState("");

	const buildTypeList = useMemo(() => {
		return [
			{ value: "ENVIRONMENT", label: "基于应用环境" },
			{ value: "OPERATOR", label: "基于流式算子" },
		];
	}, []);

	/** 切换类型 */
	const handleRadio = (val: IBuildType) => {
		setBatchBuildType(val);
	};

	const handleSubmit = () => {
		console.log(33);
	};

	return (
		<div className={style.addOperatorBox}>
			<div className={style.left}>
				<SwitchBatchFolw
					active={taskType}
					setActive={setTaskType}
					goBack={() => setAddOpen(false)}
				></SwitchBatchFolw>
			</div>
			<div className={style.right}>
				<div className={style.title}>
					{taskType === "BATCH" ? "批式算子信息" : "流式算子信息"}
				</div>
				<div style={{ paddingBottom: "20px" }}>
					<RadioGroupOfButtonStyle
						RadiosBoxStyle={{ width: 236 }}
						value={batchBuildType}
						radioOptions={buildTypeList}
						handleRadio={handleRadio}
					/>
				</div>
				<div className={style.content}>
					<div className={style.form}>4242</div>
					<div className={style.codeBox}>
						<div className={style.codeTitle}>参数配置</div>
						<div className={style.code}>
							<Code
								value={code}
								onChange={(e: string) => setCode(e)}
								height="535px"
							/>
						</div>
					</div>
				</div>
				<div className={style.parameterConfigBox}>
					<div className={style.codeTitle}>
						{batchBuildType === "ENVIRONMENT" ? "参数配置" : "流程编排"}
					</div>
					{batchBuildType === "ENVIRONMENT" ? (
						<div className={style.code}>
							<Code
								value={code}
								onChange={(e: string) => setCode(e)}
								height="350px"
							/>
						</div>
					) : (
						<div
							id="customOperatorFlow"
							style={{ position: "relative", height: 400 }}
						>
							<OperatorList
								operatorList={operatorList}
								setOperatorList={setOperatorList}
								setInputActive={setInputActive}
							/>
							<BatchOperatorFlow
								tasks={operatorList}
								setTasks={setOperatorList}
								type="edit"
								// onFlowNodeClick={handleNodeClick}
								flowNodeDraggable={true}
								ListenState={!inputActive}
								showVersion={true}
								showControls={false}
							/>
						</div>
					)}
				</div>
				<div className={style.buttonBox}>
					<MyButton text="开始构建" onClick={() => handleSubmit()}></MyButton>
				</div>
			</div>
		</div>
	);
};
export default AddEnvironment;
