/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-18 17:56:47
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import styles from "./index.module.css";
import BasicInfo from "../../../components/BasinInfo";
import { useMemo, useState } from "react";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";

const OperatorDetails = () => {
	const contentTypeList = useMemo(() => {
		return [
			{ value: "flowChart", label: "流程图" },
			{ value: "parameterList", label: "参数列表" },
			{ value: "runScript", label: "运行脚本" },
		];
	}, []);

	/** 详情类型 */
	const [contentType, setContentType] = useState<string>("flowChart");

	/** 切换类型 */
	const handleRadio = (val: string) => {
		setContentType(val);
	};

	return (
		<div className={styles.detailsBox}>
			<h2 className={styles.titleBox}>基础信息</h2>
			<div style={{ border: "1px solid #EBEDF0" }}>
				<BasicInfo
					infoList={[
						{ label: "33333331", value: "1" },
						{
							label: "1",
							value: "42543253245325325432452345235432452323542352354235235321",
						},
						{ label: "1", value: "1" },
						{ label: "1", value: "1" },
						{ label: "1", value: "1" },
					]}
				/>
				<BasicInfo infoList={[{ label: "2", value: "2" }]} />
			</div>
			<div style={{ padding: "26px 0 16px 0" }}>
				<RadioGroupOfButtonStyle
					RadiosBoxStyle={{ width: 254 }}
					value={contentType}
					radioOptions={contentTypeList}
					handleRadio={handleRadio}
				/>
			</div>
			<div>11</div>
		</div>
	);
};

export default OperatorDetails;
