/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-18 17:05:49
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// 应用环境
import { useState } from "react";

import SearchInput from "@/components/BusinessComponents/SearchInput";
import MySelect from "@/components/mui/MySelect";
import MyButton from "@/components/mui/MyButton";
import OperatorCard from "./components/OperatorCard";
import AddOperator from "./components/AddOperator";
import styles from "./index.module.css";

const WorkflowOperator = () => {
	const [addOpen, setAddOpen] = useState<boolean>(false);
	return (
		<>
			<div className={styles.indexBox}>
				<div className={styles.headerBox}>
					<div>
						<SearchInput
							sx={{ width: 340, marginRight: "16px" }}
							placeholder="输入关键词搜索"
						/>
						<MySelect
							options={[
								{
									label: "环境类型",
									value: "a",
								},
							]}
							placeholder="环境类型"
							className={styles.searchSelectBox}
							sx={{ width: "150px", height: "32px" }}
						/>
						<MySelect
							options={[
								{
									label: "环境类型",
									value: "a",
								},
							]}
							placeholder="批/流类型"
							className={styles.searchSelectBox}
							sx={{ width: "150px", height: "32px" }}
						/>
					</div>
					<MyButton
						text="构建算子"
						img={
							<span
								style={{ fontSize: "14px", marginRight: "8px" }}
								className="iconfont icon-dianzan"
							></span>
						}
						onClick={() => setAddOpen(true)}
					></MyButton>
				</div>
				<div className={styles.contentBox}>
					{[1, 2, 3, 4, 5].map((item) => {
						return <OperatorCard />;
					})}
				</div>
			</div>
			{addOpen && <AddOperator setAddOpen={setAddOpen} />}
		</>
	);
};

export default WorkflowOperator;
