/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-07-20 17:36:55
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-07-26 17:48:14
 * @FilePath: /bkunyun/src/components/BusinessComponents/NoProject/NoProject.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import style from "./NoProject.module.css";
import noData from "@/assets/project/noData.svg";
import AddIcon from "@mui/icons-material/Add";
import AddProject from "@/views/Project/components/AddProject";
import React, { useState } from "react";
import MyButton from "@/components/mui/MyButton";

const NoProject = () => {
	// 新建弹窗显示控制
	const [addOpen, setAddOpen] = useState(false);

	return (
		<div className={style.noProject}>
			<img src={noData} alt="" className={style.noDataImg} />
			<div className={style.text1}>当前产品暂无项目</div>
			<div className={style.text2}>请先创建项目</div>
			<MyButton
				text='创建项目'
				variant="contained"
				size="large"
				startIcon={<AddIcon />}
				onClick={() => setAddOpen(true)}
				style={{ backgroundColor: "#1370ff", color: "#fff" }}
			/>
				
			
			<AddProject addOpen={addOpen} setAddOpen={setAddOpen} />
		</div>
	);
};

export default NoProject;
