import React, { useCallback, useEffect, useState } from "react";
import { observer } from "mobx-react-lite";
import FullScreenDrawer from "@/components/CommonComponents/FullScreenDrawer";
import MyButton from "@/components/mui/MyButton";
import OperatorList from "./components/OperatorList";
import Flow from "../Project/components/Flow";
import styles from "./index.module.css";

type IProps = {
	setShowCustomOperator: any;
};

const CustomOperator = observer((props: IProps) => {
	const { setShowCustomOperator } = props;
	// const [showCustomOperator, setShowCustomOperator] = useState(false);

	return (
		<FullScreenDrawer handleClose={setShowCustomOperator} zIndex={1100}>
			<div className={styles.customOperator}>
				<div className={styles.coTop}>
					<div className={styles.coTitle}>添加算子</div>
					<MyButton text="添加"></MyButton>
				</div>
				<div className={styles.coContent}>
					<OperatorList />
					<Flow
						showControls={false}
						// tasks={templateConfigInfo}
						// setTasks={setTemplateConfigInfo}
						type="edit"
						// onFlowNodeClick={handleNodeClick}
						// ListenState={!saveFormDialog}
					/>
				</div>
			</div>
		</FullScreenDrawer>
	);
});

export default CustomOperator;
