import { Box, List } from "@mui/material";
import CurrentProject from "../Project/components/CurrentProject";
import React from "react";
import { Outlet, useNavigate } from "react-router-dom";
import style from "./index.module.css";
import { observer } from "mobx-react-lite";
import { useStores } from "@/store/index";
import classnames from "classnames";
import { toJS } from "mobx";

const MenuLayout = observer(() => {
  const { permissionStore, currentProjectStore } = useStores();
  let pathname = new URL(window.location.href).pathname;

  const navigate = useNavigate();

  const productInfo = toJS(currentProjectStore.currentProductInfo);

  // 未选择产品时 直接跳转home页面
  if (!productInfo.name) {
    navigate("/home");
  }

  return (
    <Box className={style.container}>
      <Box className={style.aside}>
        <CurrentProject />
        <List>
          {permissionStore.sidebarRouters.map((item, index) => {
            if (item.show) {
              return (
                <li
                  key={"sidebar" + index}
                  className={classnames({
                    [style.listItem]: true,
                    [style.active]: `/v3${item.path}` === pathname,
                  })}
                  onClick={() => item.type === "page" && navigate(item.path)}
                >
                  {item.name}
                </li>
              );
            }
            return null;
          })}
        </List>
      </Box>
      <Box className={style.content}>
        <Outlet></Outlet>
      </Box>
    </Box>
  );
});

export default MenuLayout;
