/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-13 16:51:56
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useMemo } from "react";

import { Box } from "@mui/system";
import { useStores } from "@/store/index";
import NoProject from "@/components/BusinessComponents/NoProject";
import { observer } from "mobx-react-lite";
import projectImg from "@/assets/project/projectIconSmall.svg";
import ProjectMembers from "./ProjectMembers";
import BaseInfo from "./BaseInfo";
import Tabs from "@/components/mui/Tabs";
import usePass from "@/hooks/usePass";

const ProjectSetting = observer(() => {
	const { currentProjectStore } = useStores();
	const isPass = usePass();
	const tabList = useMemo(() => {
		return [
			{
				label: "项目成员",
				value: "projectMember",
				hide: !isPass("PROJECT_SETTING_MEMBER"),
				component: <ProjectMembers />,
			},
			{
				label: "基础信息",
				value: "baseInfo",
				component: <BaseInfo />,
			},
		];
	}, []);

	if (currentProjectStore.currentProjectInfo.name) {
		return (
			<div style={{ padding: 24 }}>
				<div style={{ display: "flex", alignItems: "center" }}>
					<img src={projectImg} alt="项目logo" />
					<span style={{ marginLeft: 12 }}>
						{currentProjectStore.currentProjectInfo.name}
					</span>
				</div>
				<Box sx={{ width: "100%", typography: "body1" }}>
					<Tabs tabList={tabList} />
				</Box>
			</div>
		);
	} else {
		return <NoProject />;
	}
});

export default memo(ProjectSetting);
