import React, { FC } from "react";

import { Typography, Menu, MenuItem, IconButton, Button } from "@mui/material";
import { makeStyles } from "@mui/styles";
import ArrowDropDownIcon from '@mui/icons-material/ArrowDropDown';
import cx from "classnames"

type ButtonTagProps = {
    text: string;
    variant?: "text" | 'contained' | 'outlined';
    click: any;
    select?: any[];
    fontSize?: string;
    dropValue?: boolean;
    drop?: boolean;
    color?: "inherit" | "primary" | "secondary" | "success" | "error" | "info" | "warning" | undefined,

}

const useStyles = makeStyles({
    root: { backgroundColor: "#136EFA", boxShadow: "none !important", color: "#ffffff", "&:hover": { backgroundColor: "#ffffff  !important" } },
    ArrowDropDownIconRoot: { color: "#8A9099", transition: "all 0.2s !important", transform: "rotate(0)" },
    ArrowDropDownIconRootOpen: { color: "#8A9099", transform: "rotate(180deg)" },

})

const ButtonComponent = (props: ButtonTagProps) => {
    const classes = useStyles();
    const [anchorEl, setAnchorEl] = React.useState(null);

    const handleClick = (event: { currentTarget: React.SetStateAction<null>; }) => setAnchorEl(event.currentTarget);
    const defultClick = (event: { stoppropagation: () => any; }) => event && event.stoppropagation && event.stoppropagation()
    const handleClose = () => setAnchorEl(null);

    return (
        <>
            <Button
                variant={props.variant || 'contained'}
                color={props.color || "primary"}
                disableRipple={true}
                disableFocusRipple={true}
                classes={{
                    root: classes.root,
                }}

                sx={{ color: "#565C66" }}//暂定

                onClick={props.select ? handleClick : (props.click || defultClick)}
            >
                <Typography style={{ fontSize: props.fontSize || "14px" }}>{props.text}</Typography>
                {
                    (props.select && props.select.length > 0 || props.drop) && <ArrowDropDownIcon classes={{
                        root: cx({
                            [classes.ArrowDropDownIconRoot]: true,
                            [classes.ArrowDropDownIconRootOpen]: Boolean(props.dropValue || anchorEl)
                        })
                    }} />
                }
            </Button>
            <Menu
                id="product-menu"
                keepMounted
                anchorEl={anchorEl}
                open={Boolean(anchorEl)}
                onClose={handleClose}
                MenuListProps={{
                    "aria-labelledby": "product-button",
                }}
            >
                {
                    props.select && props.select.length > 0 && props.select.map((item, key) => {
                        return (
                            <MenuItem
                                key={item.path}


                                onClick={() => {
                                    // navigate(item.path);
                                    handleClose();
                                }}
                            >
                                {item.name}
                            </MenuItem>
                        );
                    })}
            </Menu>
        </>


    )


}

export default ButtonComponent;