import React, { useEffect } from "react";
import { Outlet, useLocation, useNavigate } from "react-router-dom";
import cx from "classnames";
import { observer } from "mobx-react-lite";
import ArrowDropDownIcon from "@mui/icons-material/ArrowDropDown";
import Avatar from "@mui/material/Avatar";
import { Box, Menu, MenuItem } from "@mui/material";

import uploadIcon from "@/assets/img/uploadIcon.svg";
import globalText from "@/utils/globalText_CN";
import useIndex from "./useIndex";
import { useStores } from "@/store/index";
import Button from "@/components/mui/Button";
import logo from "@/assets/img/logo.svg";
import MyPopover from "@/components/mui/MyPopover";
import TranSferList from "./components/TransferList";

import style from "./index.module.css";

const ConsoleLayout = observer(() => {
  const {
    productAnchorEl,
    utilityAnchorEl,
    productOpen,
    utilityOpen,
    handleProductClick,
    handleUtilityClick,
    handleClose,
  } = useIndex();

  const navigate = useNavigate();
  const location = useLocation();
  const { permissionStore, menuStore } = useStores();

  useEffect(() => {
    permissionStore.setSidebarRouters(location.pathname);
  }, [location, permissionStore]);

  return (
    <Box>
      <Box className={style.topApp}>
        <Box className={style.topLeftBox}>
          <img src={logo} alt="" className={style.logo} />

          <Button
            text={globalText.console}
            variant={"text"}
            click={() => navigate("/home")}
          />

          <Box sx={{ display: "flex", alignItems: "center" }}>
            <Button
              text={globalText.product}
              variant={"text"}
              click={handleProductClick}
              dropValue={productOpen}
              drop={true}
            />

            {/* <ArrowDropDownIcon classes={{
              root: cx({
                [style.ArrowDropDownIconRoot]: true,
                [style.ArrowDropDownIconRootOpen]: Boolean(productOpen)
              })
            }} /> */}

            <Menu
              id="product-menu"
              anchorEl={productAnchorEl}
              open={productOpen}
              onClose={handleClose}
              classes={{
                paper: style.menuPaper,
              }}
              MenuListProps={{
                "aria-labelledby": "product-button",
              }}
            >
              {menuStore.productList.map((item) => {
                return (
                  <MenuItem
                    key={item.path}
                    classes={{
                      root: style.menuItemRoot,
                    }}
                    onClick={() => {
                      navigate(item.path);
                      handleClose();
                    }}
                  >
                    {item.name}
                  </MenuItem>
                );
              })}
            </Menu>
          </Box>
        </Box>

        <Box className={style.topRightBox}>
          <MyPopover
            content={<TranSferList />}
            transformOrigin={{
              vertical: "top",
              horizontal: "right",
            }}
          >
            <Box className={style.topRightItem}>
              <img
                src={uploadIcon}
                alt=""
                style={{ verticalAlign: "middle" }}
              />
            </Box>
          </MyPopover>
          <Box className={style.topRightItem}>
            <Box
              sx={{ display: "flex", alignItems: "center" }}
              onClick={handleUtilityClick}
            >
              <Avatar
                sx={{
                  bgcolor: "#1370FF",
                  width: 28,
                  height: 28,
                  fontSize: "14px",
                  cursor: "pointer",
                }}
              >
                H
              </Avatar>
              <ArrowDropDownIcon
                classes={{
                  root: cx({
                    [style.ArrowDropDownIconRoot]: true,
                    [style.ArrowDropDownIconRootOpen]: Boolean(utilityOpen),
                  }),
                }}
              />
            </Box>

            <Menu
              id="utility-menu"
              anchorEl={utilityAnchorEl}
              open={utilityOpen}
              onClose={handleClose}
              MenuListProps={{
                "aria-labelledby": "utility-button",
              }}
            >
              {menuStore.utilityList.map((item) => {
                return (
                  <MenuItem
                    key={item.path}
                    onClick={() => {
                      navigate(item.path);
                      handleClose();
                    }}
                  >
                    {item.name}
                  </MenuItem>
                );
              })}
            </Menu>
          </Box>
        </Box>
      </Box>
      <Box>
        <Outlet></Outlet>
      </Box>
    </Box>
  );
});

export default ConsoleLayout;
