/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-07 21:39:30
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useCallback, useEffect, useMemo, useState } from "react";
import { Box, Typography } from "@mui/material";
import styles from "./index.module.css";
import OutlinedInput from "@mui/material/OutlinedInput";
import SearchIcon from "@mui/icons-material/Search";
// import Button from "@/components/mui/Button";
import Button from "@mui/material/Button";
import Add from "@mui/icons-material/Add";
import useMyRequest from "@/hooks/useMyRequest";
import TemplateBox from "./components/templateBox"
import SimpleDialog from "./components/simpleDialog"
import AddTemplate from "./components/addTemplate"
import noData from '../../../../assets/project/noTemplate.svg'
import {
    getWorkbenchTemplate,
    deleteWorkbenchTemplate,
    getAddWorkbenchTemplate,
    addWorkbenchTemplate
} from "@/api/workbench_api";
import _ from "lodash";
import { IResponse, useHttp } from "@/api/http";
import { useStores } from "@/store";
import usePass from "@/hooks/usePass";

const ProjectMembers = () => {
    const { currentProjectStore } = useStores();
    const isPass = usePass();

    /** 搜索模板名称 */
    const [templateName, setTemplateName] = useState("");
    /** 模板列表 */
    const [templateList, setTemplateList] = useState([]);
    /** 选中的模板id */
    const [templateId, setTemplateId] = useState('');
    /** 简单弹窗（删除模板） */
    const [openDialog, setOpenDialog] = useState(false);
    /** 增加模板 */
    const [openAddTemplate, setOpenAddTemplate] = useState(false);
    /** 可增加模板列表 */
    const [addTemplateList, setAddTemplateList] = useState([]);
    /** 已选择增加的模板列表 */
    const [selectTemplateData, setSelectTemplateData] = useState<string[]>([]);

    // 获取模板列表
    const { run: getTemplateInfo } = useMyRequest(getWorkbenchTemplate, {
        onSuccess: (result: any) => {
            setTemplateList(result.data);
        },
    });

    // 删除模板
    const { run: delTemplate } = useMyRequest(deleteWorkbenchTemplate, {
        onSuccess: (result: any) => {
            setOpenDialog(false);
            getTemplateInfo({
                projectId: currentProjectStore.currentProjectInfo.id as string,
                title: templateName
            });
        },
    });

    // 添加工作流模板-获取模板列表
    const { run: getAddTemplateList } = useMyRequest(getAddWorkbenchTemplate, {
        onSuccess: (result: any) => {
            setAddTemplateList(result.data)
            setOpenAddTemplate(true);
        },
    });

    // 项目管理员-添加工作流模板-提交
    const { run: addTemplate } = useMyRequest(addWorkbenchTemplate, {
        onSuccess: (result: any) => {
            setOpenAddTemplate(false)
            getTemplateInfo({
                projectId: currentProjectStore.currentProjectInfo.id as string,
            });
            setSelectTemplateData([])
        },
    });

    useEffect(() => {
        getTemplateInfo({
            projectId: currentProjectStore.currentProjectInfo.id as string,
        });
    }, [currentProjectStore.currentProjectInfo.id, getTemplateInfo]);

    /** 点击添加工作流模版 */
    const onAddMember = () => {
        // setAddMemberDialog(true);
    };

    /** 删除模板 */
    const deleteTemplate = () => {
        delTemplate({
            projectId: currentProjectStore.currentProjectInfo.id as string,
            workflowSpecId: templateId,
        })
    };

    /** 打开弹窗 */
    const startDialog = (id: string) => {
        setTemplateId(id)
        setOpenDialog(true);
    };

    /** 关闭弹窗 */
    const closeDialog = () => {
        setOpenDialog(false);
    };

    /** 增加模板 */
    const addTemplateBlock = () => {
        getAddTemplateList({
            projectId: currentProjectStore.currentProjectInfo.id as string,
            productId: 'cadd',
        })
    };

    /** 关闭增加模板 */
    const closeAddTemplateBlock = () => {
        setOpenAddTemplate(false);
        setSelectTemplateData([])
    };

    /** 增加模板操作 */
    const addTemplateCallback = () => {
        addTemplate({
            projectId: currentProjectStore.currentProjectInfo.id as string,
            workflowSpecIds: selectTemplateData
        })
    }

    /** 搜索模板 */
    const searchTemplateNameCallback = (data: any) => {
        getAddTemplateList({
            projectId: currentProjectStore.currentProjectInfo.id as string,
            productId: 'cadd',
            title: data
        })
    }

    const templateSelectCallback = (data: string) => {
        let list: string[] = [...selectTemplateData]
        if (selectTemplateData.filter(e => e === data).length > 0) {
            list = list.filter(e => e !== data)
            setSelectTemplateData(list)
        } else {
            list.push(data)
            setSelectTemplateData(list)
        }

    }

    useEffect(() => {
        getTemplateInfo({
            projectId: currentProjectStore.currentProjectInfo.id as string,
            title: templateName
        });
    }, [templateName]);

    return (
        <Box className={styles.headerBox}>

            <Box className={styles.tabBox} >
                <OutlinedInput
                    onChange={(e: any) => {
                        _.debounce(() => {
                            setTemplateName(e.target.value);
                        }, 200)();
                    }}
                    placeholder="输入关键词搜索"
                    size="small"
                    sx={{ width: 340, height: 32 }}
                    endAdornment={<SearchIcon style={{ color: "#8A9099" }} />}
                />

                {
                    templateList.length > 0 && isPass("PROJECT_WORKBENCH_FLOES_ADD", 'MANAGER') && <Button
                        style={{ backgroundColor: "#1370FF " }}
                        variant="contained"
                        onClick={addTemplateBlock}
                        startIcon={<Add />}
                        size="small"
                    >
                        添加工作流模版
                    </Button>
                }

            </Box>

            {
                templateList.length === 0 && !isPass("PROJECT_WORKBENCH_FLOES_ADD", 'MANAGER') &&
                <Box sx={{
                    display: 'flex', alignItems: 'center', flexDirection: 'column', minHeight: 'calc(100vh - 376px)',
                    justifyContent: 'center'
                }}>
                    <img alt="" src={noData} />
                    <Typography sx={{ fontSize: '12px', fontWeight: '400', color: '#8A9099' }}>暂未开启模版</Typography>
                </Box>
            }
            {
                templateList.length > 0 && <Box sx={{ display: "flex", flexWrap: 'wrap', marginLeft: "-8px" }} >
                    {
                        templateList && templateList.length > 0 && templateList.map((item, key) => {
                            return <TemplateBox data={item} startDialog={startDialog} />
                        })
                    }
                </Box>
            }
            {
                templateList.length === 0 && isPass("PROJECT_WORKBENCH_FLOES_ADD", 'MANAGER') && <Box className={styles.addNewTemplate}
                    onClick={addTemplateBlock}
                >
                    <Add sx={{ color: "#565C66", fontSize: "20px", width: "30px", height: '30px' }} />
                    <Typography sx={{ fontSize: '14px', fontWeight: '400', color: '#8A9099', marginTop: "15px" }}>添加工作流模版</Typography>
                </Box>
            }

            <AddTemplate
                openAddTemplate={openAddTemplate}
                closeAddTemplateBlock={closeAddTemplateBlock}
                addTemplateList={addTemplateList}
                templateSelectCallback={templateSelectCallback}
                selectTemplateData={selectTemplateData}
                addTemplateCallback={addTemplateCallback}
                searchTemplateNameCallback={searchTemplateNameCallback}
            />

            <SimpleDialog
                text={'确认移除该模板吗？'}
                title={'删除模板'}
                openDialog={openDialog}
                closeDialog={closeDialog}
                onConfirm={deleteTemplate}
            />

        </Box>
    );
};

export default memo(ProjectMembers);
