/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-11 11:56:58
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-21 18:30:18
 * @FilePath: /bkunyun/src/components/mui/MySwitch.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import * as React from "react";
import Switch, { SwitchProps } from "@mui/material/Switch";
import { ThemeProvider, createTheme } from "@mui/material/styles";

interface IMySwitchProps extends SwitchProps {
	value?: boolean;
	defaultChecked?: boolean;
	onChange?: any;
	disabled?: boolean;
}

const theme = createTheme({
	components: {
		MuiSwitch: {
			styleOverrides: {
				root: {
					boxSizing: "border-box",
					padding: "0",
				},
				switchBase: {
					top: "4px",
					left: "4px",
					padding: 0,
					"&.Mui-checked": {
						left: "2px",
						"& + .MuiSwitch-track": {
							backgroundColor: "#1370ff",
							opacity: 1,
						},
					},
				},
				thumb: {
					width: "14px",
					height: "14px",
					color: "#fff",
				},
				track: {
					borderRadius: "11px",
					backgroundColor: "#E6E8EB",
					opacity: 1,
				},
			},
		},
	},
});

const MySwitch = (props: IMySwitchProps) => {
	const { value, defaultChecked, onChange, disabled = false, size, ...other } = props;
	return (
		<ThemeProvider theme={theme}>
			<Switch
				checked={value}
				disabled={disabled}
				defaultChecked={defaultChecked}
				onChange={onChange}
				sx={
					size === "medium"
						? {
							width: 44,
							height: 24,
						}
						: {
							width: 40,
							height: 22,
						}
				}
				{...other}
			/>
		</ThemeProvider>
	);
};

export default MySwitch;
