/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-20 17:11:22
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// 应用环境
import { useCallback, useEffect, useState } from "react";
import { observer } from "mobx-react";
import _ from "lodash";
import Add from "@mui/icons-material/Add";

import SearchInput from "@/components/BusinessComponents/SearchInput";
import MySelect from "@/components/mui/MySelect";
import MyButton from "@/components/mui/MyButton";
import OperatorCard from "./components/OperatorCard";
import AddOperator from "./components/AddOperator";
import { useStores } from "@/store";
import { getOperatorList, IOperatorListParams } from "@/api/resourceCenter";
import useMyRequest from "@/hooks/useMyRequest";
import { IOperatorInfo } from "./interface";

import styles from "./index.module.css";

const WorkflowOperator = observer(() => {
	const [pageType, setPageType] = useState<string>("");
	/** 产品store */
	const { productListStore } = useStores();
	/**  算子列表参数 */
	const [searchParams, setSearchParams] = useState<IOperatorListParams>({
		keyword: "",
		productId: "all",
		type: "all",
	});

	const [list, setList] = useState<IOperatorInfo[]>();

	const { run: getList } = useMyRequest(getOperatorList, {
		// refreshDeps: [],
		onSuccess: (res) => {
			console.log(res);
			setList(res?.data);
		},
	});

	const newGetList = useCallback(() => {
		const params = _.cloneDeep(searchParams);
		if (params.productId === "all") {
			params.productId = "";
		}
		if (params.type === "all") {
			params.type = "";
		}
		getList(params);
	}, [getList, searchParams]);

	// 按回车搜索
	const handleKeyWordChangeKeyUp = (e: any) => {
		if (e.keyCode === 13) {
			newGetList();
		}
	};

	useEffect(() => {
		newGetList();
	}, [searchParams.productId, searchParams.type]);

	return (
		<>
			<div className={styles.indexBox}>
				<div className={styles.headerBox}>
					<div>
						<SearchInput
							sx={{ width: 340, marginRight: "16px" }}
							placeholder="输入关键词搜索"
							value={searchParams.keyword}
							onKeyUp={handleKeyWordChangeKeyUp}
							onChange={(e) => {
								setSearchParams({ ...searchParams, keyword: e.target.value });
							}}
						/>
						<MySelect
							title="所属产品"
							isTitle={true}
							options={
								[
									{ label: "全部", value: "all" },
									...productListStore?.productList,
								] || []
							}
							value={searchParams.productId}
							onChange={(e) => {
								setSearchParams({ ...searchParams, productId: e });
							}}
							className={styles.searchSelectBox}
							sx={{ width: "150px", height: "32px" }}
						/>
						<MySelect
							title="环境类型"
							isTitle={true}
							value={searchParams.type}
							onChange={(e) => {
								setSearchParams({ ...searchParams, type: e });
							}}
							options={[
								{ label: "全部", value: "all" },
								{
									label: "批式",
									value: "BATCH",
								},
								{
									label: "流式",
									value: "FLOW",
								},
							]}
							sx={{ width: "150px", height: "32px" }}
						/>
					</div>
					<MyButton
						text="构建算子"
						startIcon={<Add />}
						onClick={() => setPageType("add")}
					></MyButton>
				</div>
				<div className={styles.contentBox}>
					{list?.map((item) => {
						return (
							<OperatorCard operatorInfo={item} setPageType={setPageType} />
						);
					})}
				</div>
			</div>
			{pageType && (
				<AddOperator setPageType={setPageType} pageType={pageType} />
			)}
		</>
	);
});

export default WorkflowOperator;
