import batchImg from "@/assets/resourceCenter/batchImg.svg";
import flowImg from "@/assets/resourceCenter/flowImg.svg";
import classNames from "classnames";
import goback from "@/assets/project/goback.svg";
import style from "./index.module.css";

type ISwitchBatchFolwProps = {
	active: "BATCH" | "FLOW";
	setActive: any;
	goBack: any;
};

const SwitchBatchFolw = (props: ISwitchBatchFolwProps) => {
	const { active, setActive, goBack } = props;
	return (
		<div className={style.switchBatchFolw}>
			<div className={style.goBackBox}>
				<img
					className={style.goBackIcon}
					src={goback}
					alt=""
					onClick={() => goBack()}
				/>
				<span className={style.goBackText}>返回</span>
			</div>
			<div className={style.switchBox}>
				<div
					className={classNames({
						[style.switchItem]: true,
						[style.activeSwitchItem]: active === "BATCH",
					})}
				>
					<img
						onClick={() => setActive("BATCH")}
						className={classNames({
							[style.itemImg]: true,
							[style.activeImg]: active === "BATCH",
						})}
						src={batchImg}
						alt=""
					/>
					{active === "BATCH" && <div className={style.arrow}></div>}
				</div>
				<div
					className={classNames({
						[style.switchItem]: true,
						[style.activeSwitchItem]: active === "FLOW",
					})}
				>
					<img
						onClick={() => setActive("FLOW")}
						className={classNames({
							[style.itemImg]: true,
							[style.activeImg]: active === "FLOW",
						})}
						src={flowImg}
						alt=""
					/>
					{active === "FLOW" && <div className={style.arrow}></div>}
				</div>
			</div>
		</div>
	);
};

export default SwitchBatchFolw;
