import style from "./index.module.css";

interface ICardTableProps {
	data: Array<any>; // 列表数据
	renderItem: any; // 单个卡片的渲染函数
	tableKey?: string; // 表格数据的key
	numberOfColumns?: number; // 列数   每行渲染几个
	horizontalSpacing?: number; // 水平方向的间隔
	verticalSpacing?: number; // 垂直方向的间隔
}

const CardTable = (props: ICardTableProps) => {
	const {
		data,
		renderItem,
		tableKey = "id",
		numberOfColumns = 3,
		horizontalSpacing = 20,
		verticalSpacing = 20,
	} = props;
	return (
		<div
			className={style.tableBox}
			style={{
				marginLeft: `-${horizontalSpacing / 2}px`,
				marginRight: `-${horizontalSpacing / 2}px`,
			}}
		>
			{data.map((item, index) => {
				return (
					<div
						className={style.itemBox}
						key={item[tableKey] ? item[tableKey] : index}
						style={{
							width: `${100 / numberOfColumns}%`,
							paddingLeft: `${horizontalSpacing / 2}px`,
							paddingRight: `${horizontalSpacing / 2}px`,
							paddingBottom: `${verticalSpacing}px`,
							boxSizing: "border-box",
						}}
					>
						{renderItem(item, index)}
					</div>
				);
			})}
		</div>
	);
};

export default CardTable;
