import CodeMirror from "@uiw/react-codemirror";

type ICodeType = {
	value: string;
	onChange: any;
	height?: string;
	width?: string;
	maxWidth?: string;
	theme?: "light" | "dark";
};

const Code = (props: ICodeType) => {
	const { value, onChange, height, theme = "dark", width, maxWidth } = props;
	return (
		<CodeMirror
			height={height || "100%"}
			width={width || "100%"}
			maxWidth={maxWidth || "100%"}
			value={value}
			onChange={(e) => onChange(e)}
			theme={theme}
		/>
	);
};
export default Code;
