/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-20 17:36:14
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-20 19:44:52
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/components/AddOperator/utils.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import { IOperatorAddFormData } from "../../interface";


export const checkFormData = (formData: IOperatorAddFormData, taskType: 'BATCH' | 'FLOW')=>{
  const reg = new RegExp("^[A-Za-z0-9\u4e00-\u9fa5]{1,15}$");

  const result:IOperatorAddFormData = {}

  if(!formData?.title){
    result.title = '请输入算子名称'
  }
  if(!reg.test(formData?.title || '')){
    result.title = '格式不正确,仅限大小写字母、数字、中文'
  }
  if(!/^[1-9]\d?(\.(0|[1-9]\d?)){2}$/.test(formData?.version || '')){
    result.version = '格式不正确,必须为X.Y.Z格式,且XYZ必须为0~99的正整数'
  }
  if(!formData?.version){
    result.version = '请输入算子版本'
  }
  if(!formData?.productId){
    result.productId = '请选择所属产品'
  }
  if(taskType ==='BATCH' && !formData?.envId){
    result.envId = '请选择应用环境'
  }
  
  return result
}

/** 参数配置校验 */
export const checkParamsConfig = (val: string) => {
  let result: string = ''
  const arr = val.split('\n' || ',')

  if(!val){
    result = '请输入参数配置'
  }
  if(!true){
    result = '参数配置格式不正确'
  }
  
  return result
}