/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-15 15:47:16
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-23 11:32:19
 * @FilePath: /bkunyun/src/views/WorkFlowEdit/components/SaveCustomTemplate/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { saveUserSpec } from "@/api/workbench_api";
import MyDialog from "@/components/mui/MyDialog";
import MyInput from "@/components/mui/MyInput";
import { checkIsNumberLetterChinese } from "@/utils/util";
import { useState } from "react";
import useMyRequest from "@/hooks/useMyRequest";

import styles from "./index.module.css";
import { useMessage } from "@/components/MySnackbar";
import { ITask } from "@/views/Project/ProjectSubmitWork/interface";
interface IProps {
	saveFormDialog: boolean;
	setSaveFormDialog: (val: boolean) => void;
	onBack?: () => void;
	title: string;
	setTitle: (val: string) => void;
	version: string;
	setVersion: (val: string) => void;
	description: string;
	setDescription: (val: string) => void;
	oldversion: string;
	creator?: string;
	templateConfigInfo: ITask[];
	id?: string;
	productId: string;
}
const SaveCustomTemplate = (props: IProps) => {
	const {
		saveFormDialog,
		setSaveFormDialog,
		onBack,
		title,
		setTitle,
		version,
		setVersion,
		description,
		setDescription,
		oldversion,
		templateConfigInfo,
		creator,
		id,
		productId,
	} = props;
	const Message = useMessage();
	const [titleHelper, setTitleHelper] = useState({
		// 自定义模板名称错误提示
		error: false,
		helperText: "",
	});
	const [versionHelper, setVersionHelper] = useState({
		// 自定义模板版本错误提示
		error: false,
		helperText: "",
	});

	// 自定义模板保存方法
	const { run: saveUserSpecRun, loading } = useMyRequest(saveUserSpec, {
		onSuccess: (res) => {
			Message.success("保存成功!");
			onBack && onBack();
		},
	});

	// 关闭表单弹窗
	const handleCloseDialog = () => {
		setSaveFormDialog(false);
	};

	// 自定义模板名称
	const handleTitleChange = (e: any) => {
		const title = e.target.value;
		setTitle(title);
		checkTitle(title);
		// 格式不正确，必须在15字符以内，仅限大小写字母、数字、中文
	};

	// 自定义模板版本
	const handleVersionChange = (e: any) => {
		let version = e.target.value;
		setVersion(version);
		checkVersion(version);
	};

	// 自定义模板描述
	const handleDescriptionChange = (e: any) => {
		let description = e.target.value;
		if (description.length < 301) {
			setDescription(description);
		}
	};

	// 校验模板名称
	const checkTitle = (title: string) => {
		if (!title) {
			setTitleHelper({
				error: true,
				helperText: "必须输入模板名称",
			});
			return false;
		} else if (title.length > 50) {
			setTitleHelper({
				error: true,
				helperText: "格式不正确，必须在15字符以内，仅限大小写字母、数字、中文",
			});
			return false;
		} else if (!checkIsNumberLetterChinese(title)) {
			setTitleHelper({
				error: true,
				helperText: "格式不正确，必须在15字符以内，仅限大小写字母、数字、中文",
			});
			return false;
		} else {
			setTitleHelper({
				error: false,
				helperText: "",
			});
			return true;
		}
	};

	// 校验新版本号是否大于旧版本号
	const checkNewOldVersion = (version: string, oldversion: string): boolean => {
		let versionArr: any[] = version.split(".");
		let oldversionArr: any[] = oldversion.split(".");
		versionArr = versionArr.map((item) => Number(item));
		oldversionArr = oldversionArr.map((item) => Number(item));

		if (versionArr[0] < oldversionArr[0]) {
			setVersionHelper({
				error: true,
				helperText:
					"新版本号必须大于老版本号，且必须为X.Y.Z格式，XYZ必须为0~99的正整数",
			});
			return false;
		} else if (versionArr[0] === oldversionArr[0]) {
			if (versionArr[1] < oldversionArr[1]) {
				setVersionHelper({
					error: true,
					helperText:
						"新版本号必须大于老版本号，且必须为X.Y.Z格式，XYZ必须为0~99的正整数",
				});
				return false;
			} else if (versionArr[1] === oldversionArr[1]) {
				if (versionArr[2] <= oldversionArr[2]) {
					setVersionHelper({
						error: true,
						helperText:
							"新版本号必须大于老版本号，且必须为X.Y.Z格式，XYZ必须为0~99的正整数",
					});
					return false;
				}
			}
		}
		return true;
	};

	// 校验版本号格式
	const checkVersion = (version: string) => {
		if (/^[1-9]\d?(\.(0|[1-9]\d?)){2}$/.test(version)) {
			setVersionHelper({
				error: false,
				helperText: "",
			});
			if (oldversion) {
				if (checkNewOldVersion(version, oldversion)) {
					return true;
				} else {
					return false;
				}
			} else {
				return true;
			}
		} else {
			setVersionHelper({
				error: true,
				helperText: "格式不正确，必须为X.Y.Z格式，且XYZ必须为0~99的正整数",
			});
			return false;
		}
	};

	// 表单弹窗确定，新建/编辑自定义模板保存
	const handleOncofirm = () => {
		if (checkTitle(title) && checkVersion(version)) {
			if (id) {
				saveUserSpecRun({
					title,
					version,
					description,
					tasks: templateConfigInfo,
					productId,
					id,
					creator,
				});
			} else {
				saveUserSpecRun({
					title,
					version,
					description,
					tasks: templateConfigInfo,
					productId,
				});
			}
		}
	};

	return (
		<MyDialog
			open={saveFormDialog}
			title="保存自定义模板"
			onClose={handleCloseDialog}
			onConfirm={handleOncofirm}
			loading={loading}
		>
			<div className={styles.saveBox}>
				<MyInput
					value={title}
					label="模板名称"
					onChange={handleTitleChange}
					required
					error={titleHelper.error}
					helperText={titleHelper.helperText}
					style={{ margin: "8px 0 20px" }}
					disabled={id ? true : false}
				></MyInput>
				<MyInput
					value={version}
					label="版本号"
					onChange={handleVersionChange}
					error={versionHelper.error}
					helperText={versionHelper.helperText}
					style={{ marginBottom: "20px" }}
				></MyInput>
				<div style={{ position: "relative" }}>
					<MyInput
						value={description}
						id="desc"
						label="模板描述"
						placeholder="模板描述"
						onChange={handleDescriptionChange}
						multiline
						rows={4}
					/>
					<span
						style={{
							position: "absolute",
							fontSize: "14px",
							bottom: "7px",
							right: "12px",
							color: description.length >= 300 ? "#d32f2f" : "#C2C6CC",
						}}
					>
						{description.length}/300
					</span>
				</div>
			</div>
		</MyDialog>
	);
};

export default SaveCustomTemplate;
