/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-07-26 18:39:52
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useCallback, useEffect, useMemo, useState } from "react";
import { Box } from "@mui/material";
import Add from "@mui/icons-material/Add";
import { toJS } from "mobx";
import { observer } from "mobx-react";

import MyTable from "@/components/mui/MyTableNew";
import { IResponse, useHttp } from "@/api/http";
import RemoveItem from "./components/RemoveItem";
import ChangePermission from "./components/ChangePermission";
import AddMember from "./components/AddMember";
import { IDialogInfo } from "./interface";
import { useStores } from "@/store";
import MyButton from "@/components/mui/MyButton";
import SearchInput from "@/components/BusinessComponents/SearchInput";

import styles from "./index.module.css";

const ProjectMembers = observer(() => {
	const http = useHttp();

	const { currentProjectStore } = useStores();

	/** 删除成员 */
	const [removeDialog, setRemoveDialog] = useState<IDialogInfo>({
		isShow: false,
		username: "",
	});
	/** 更改权限 */
	const [permissionDialog, setPermissionDialog] = useState<IDialogInfo>({
		isShow: false,
		username: "",
	});
	/** 添加成员 */
	const [addMemberDialog, setAddMemberDialog] = useState<boolean>(false);
	/** 表格数据 */
	const [tableData, setTableData] = useState([]);
	/** 当前项目用户权限 */
	const [projectRole, setProjectRole] = useState<string>("");
	/** 项目名称 */
	const [projectName, setProjectMember] = useState("");
	/** 过滤后数据 */
	const [filterTableData, setFilterTableData] = useState([]);
	const [loading, setLoading] = useState(false);

	const randerOperation = (item: any) => {
		return item?.projectRole === "OWNER" ? null : (
			<>
				<span
					style={{ color: "#1370FF", cursor: "pointer" }}
					onClick={() => {
						onPermissionBtn(item);
					}}
				>
					更改权限
				</span>
				<span
					className={styles.removeItemBox}
					onClick={() => {
						onRemoveItemBtn(item.username);
					}}
				>
					移出项目
				</span>
			</>
		);
	};

	const columns = useMemo(() => {
		let val: any = [
			{ id: "username", label: "成员名称", width: 200 },
			{ id: "projectRoleDesc", label: "项目权限", width: 200 },
			{ id: "phone", label: "联系方式" },
		];
		if (projectRole === "OWNER") {
			val.push({
				id: "operation",
				label: "操作",
				width: 180,
			});
		}
		return val;
	}, [projectRole]);

	/** 获取表格数据 */
	const getTableList = useCallback(() => {
		const projectInfo = toJS(currentProjectStore?.currentProjectInfo);
		if (!projectInfo?.id) return;
		setLoading(true);
		http
			.get<IResponse<any>>("/cpp/project/get", {
				params: { id: projectInfo?.id || "" },
			})
			.then((res) => {
				setLoading(false);
				const { data = {} } = res;
				setTableData(data?.members || []);
				setProjectRole(data?.projectRole || "");
			})
			.catch(() => {
				setLoading(false);
			});
	}, [currentProjectStore?.currentProjectInfo, http]);

	useEffect(() => {
		getTableList();
	}, [getTableList]);

	useEffect(() => {
		if (!!projectName) {
			const newVal =
				tableData.filter((item: any) => {
					return item?.username?.includes(projectName);
				}) || [];
			setFilterTableData(newVal || []);
		} else {
			setFilterTableData(tableData);
		}
	}, [projectName, tableData]);

	/** 点击添加成员 */
	const onAddMember = () => {
		setAddMemberDialog(true);
	};

	/** 点击删除成员 */
	const onRemoveItemBtn = (userName: string) => {
		setRemoveDialog({ isShow: true, username: userName });
	};

	/** 点击更改权限 */
	const onPermissionBtn = (row: any) => {
		setPermissionDialog({
			isShow: true,
			username: row?.username || "",
			projectRole: row?.projectRole || "",
		});
	};
	// 回车搜索
	const handleKeyWordChangeKeyUp = (e: any) => {
		if (e.keyCode === 13) {
			setProjectMember(e.target.value);
		}
	};

	return (
		<>
			<Box className={styles.headerBox}>
				<SearchInput
					onKeyUp={handleKeyWordChangeKeyUp}
					placeholder="输入项目成员按回车搜索"
					sx={{ width: 340 }}
				/>
				{currentProjectStore?.currentProjectInfo?.projectRole === "OWNER" ? (
					<MyButton
						text="添加成员"
						style={{ backgroundColor: "#1370FF " }}
						variant="contained"
						onClick={onAddMember}
						startIcon={<Add />}
						size="medium"
					/>
				) : null}
			</Box>
			<div className={styles.tableBox}>
				<MyTable
					fixedHead={true}
					rows={filterTableData.map((item: any, index) => ({
						...item,
						operation: randerOperation(item),
					}))}
					tableKey="username"
					headCells={columns}
					loading={loading}
				/>
			</div>
			<RemoveItem
				removeDialog={removeDialog}
				setRemoveDialog={setRemoveDialog}
				getTableList={getTableList}
			/>
			<ChangePermission
				permissionDialog={permissionDialog}
				getTableList={getTableList}
				setPermissionDialog={setPermissionDialog}
			/>
			<AddMember
				addMemberDialog={addMemberDialog}
				setAddMemberDialog={setAddMemberDialog}
				getTableList={getTableList}
			/>
		</>
	);
});

export default memo(ProjectMembers);
