/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-17 14:48:57
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-04 19:38:48
 * @FilePath: /bkunyun/src/views/Project/project.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import {
  getProjectList as getProjectListApi,
  hpczone,
  getDataFileToken,
} from "@/api/project_api";

export const getProjectList = async (id = 'cadd') => {
  const res = await getProjectListApi({ product: id });
  return res.data;
};

// 设置文件服务器指向
export const setFileServerEndPointLocalStorage = async (zoneId: string) => {
  const res = await hpczone();
  let fileServerEndPoint = "";
  if (Array.isArray(res)) {
    res.forEach((item: any) => {
      if (item.id === zoneId) {
        fileServerEndPoint = item.storageConfig?.fileServerEndPoint;
      }
    });
    localStorage.setItem("fileServerEndPoint", fileServerEndPoint);
  }
};

// 根据项目id获取文件token
export const getFiletokenAccordingToId = async (projectId: string) => {
  const res = await getDataFileToken({ id: projectId });
  return res.data;
};
