/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-20 19:45:32
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-26 17:27:12
 * @FilePath: /bkunyun/src/components/CommonComponents/Code/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import CodeMirror, { ReactCodeMirrorProps } from "@uiw/react-codemirror";
import { memo } from "react";
import { isEqual } from "lodash";
// import { javascript } from "@codemirror/lang-javascript";

interface ICodeType extends ReactCodeMirrorProps {
	height?: string;
	width?: string;
	maxWidth?: string;
	theme?: "light" | "dark";
}

const Code = (props: ICodeType) => {
	const { height, theme = "dark", width, maxWidth } = props;
	return (
		<CodeMirror
			{...props}
			height={height || "100%"}
			width={width || "100%"}
			maxWidth={maxWidth || "100%"}
			theme={theme}
		/>
	);
};

// const handleEqual = (prvProps: ICodeType, nextProps: ICodeType) => {
// 	if (isEqual(prvProps, nextProps)) {
// 		return true;
// 	}
// 	return true;
// };

export default Code;
