/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-05 14:00:37
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-06 13:52:48
 * @FilePath: /bkunyun/src/components/mui/MyCheckBox.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import * as React from "react";
import FormGroup, { FormGroupProps } from "@mui/material/FormGroup";
import FormControlLabel from "@mui/material/FormControlLabel";
import Checkbox from "@mui/material/Checkbox";
import FormControl from "@mui/material/FormControl";
import FormHelperText from "@mui/material/FormHelperText";
import { ThemeProvider, createTheme } from "@mui/material/styles";
import _ from "lodash";

interface IMyCheckBoxProps extends FormGroupProps {
	value: Array<any>;
	options: Array<ICheckBoxOption>;
	onChange: any; // 直接返回选中项的数组
	variant?: "standard" | "outlined" | "filled";
	error?: boolean;
	helperText?: string;
}

type ICheckBoxOption = {
	value: any;
	label?: string;
	disabled?: boolean;
};

export const optionsTransform = (
	arr: Array<any>,
	labelKey: string = "label",
	valueKey: string = "value",
	disabledKey: string = "disabled"
): Array<ICheckBoxOption> => {
	return arr.map((item: any) => {
		return {
			value: item[valueKey],
			label: item[labelKey],
			disabled: item[disabledKey] || false,
		};
	});
};

const theme = createTheme({
	components: {
		MuiFormControlLabel: {
			styleOverrides: {
				label: {
					fontSize: "14px",
				},
			},
		},
		MuiSvgIcon: {
			styleOverrides: {
				root: {
					color: "rgba(209, 214, 222, 1)",
					fontSize: "19px",
				},
			},
		},
		MuiCheckbox: {
			styleOverrides: {
				root: {
					"&.Mui-checked .MuiSvgIcon-root": {
						color: "rgba(19, 110, 250, 1)",
					},
				},
			},
		},
	},
});

export default function MyCheckBox(props: IMyCheckBoxProps) {
	const {
		value,
		options,
		onChange,
		error = false,
		helperText,
		variant,
	} = props;

	const getCheckedStatus = (
		checkBoxItemValue: any,
		valueArr: Array<any>
	): boolean => {
		const result = valueArr.indexOf(checkBoxItemValue);
		return result === -1 ? false : true;
	};

	const handleMyCheckBoxOnChange = (e: any) => {
		const resultArr = _.cloneDeep(value);
		const clickValue = e.target.name;
		const clickValueIndex = value.indexOf(clickValue);
		if (clickValueIndex === -1) {
			resultArr.push(clickValue);
			onChange && onChange(resultArr);
		} else {
			resultArr.splice(clickValueIndex, 1);
			onChange && onChange(resultArr);
		}
	};

	return (
		<ThemeProvider theme={theme}>
			<FormControl fullWidth variant={variant} error={error}>
				<FormGroup {...props} row>
					{options.map((option) => {
						return (
							<FormControlLabel
								key={option.value}
								control={
									<Checkbox
										checked={getCheckedStatus(option.value, value)}
										value={option.value}
									/>
								}
								label={option.label}
								name={option.value}
								onChange={handleMyCheckBoxOnChange}
								disabled={option.disabled}
							/>
						);
					})}
				</FormGroup>
				{helperText && error && <FormHelperText>{helperText}</FormHelperText>}
			</FormControl>
		</ThemeProvider>
	);
}
