import _ from "lodash";

import { useMessage } from "@/components/MySnackbar";
import { ITask } from "../Project/ProjectSubmitWork/interface";

/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-24 18:08:47
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-26 18:13:41
 * @FilePath: /bkunyun/src/views/CustomOperator/useCheckOperator.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
const useCheckOperator = (
	operatorList: ITask[],
	successCallBack?: any,
	nullText?: string
) => {
	const Message = useMessage();

	// 判断   每个起始算子（可以有多个起始点）的输入必须为文件的路径输入或数据集的路径输入。
	const checkIn = (targetArr: string[]) => {
		const uniqTargetArr = _.uniq(targetArr);
		if (uniqTargetArr.length === operatorList.length) {
			// 流节点连成一个圈了
			return false;
		}
		let check = true;
		operatorList.forEach((flowNode) => {
			if (uniqTargetArr.indexOf(flowNode.id) === -1) {
				// 该节点的输入没有连线  也就是说这个节点是起点
				const inArr = flowNode.parameters.filter(
					(parameter) => parameter.parameterGroup === "in"
				);
				if (inArr.length > 0) {
					if (
						!inArr.some((inItem) => {
							return (
								(inItem.domType || "").toLowerCase() === "dataset" ||
								(inItem.domType || "").toLowerCase() === "path" ||
								(inItem.domType || "").toLowerCase() === "file"
							);
						})
					) {
						check = false;
					}
				} else {
					// 起点没有输入
					check = false;
				}
			}
		});
		return check;
	};

	// 判断  起码有一个结尾算子（可以有多个结尾点）的输出必须为文件保存或数据集保存。
	const checkOut = (sourceArr: string[]) => {
		const uniqSourceArr = _.uniq(sourceArr);
		if (uniqSourceArr.length === operatorList.length) {
			// 流节点连成一个圈了
			return false;
		}
		let check = true;
		operatorList.forEach((flowNode) => {
			if (uniqSourceArr.indexOf(flowNode.id) === -1) {
				// 该节点的输入没有连线  也就是说这个节点是起点
				const outArr = flowNode.parameters.filter(
					(parameter) => parameter.parameterGroup === "out"
				);
				if (outArr.length > 0) {
					if (
						!outArr.some((outItem) => {
							return (
								(outItem.domType || "").toLowerCase() === "dataset" ||
								(outItem.domType || "").toLowerCase() === "file" ||
								(outItem.domType || "").toLowerCase() === "path" ||
								(outItem.domType || "").toLowerCase() === "input"
							);
						})
					) {
						check = false;
					}
				} else {
					// 起点没有输入
					check = false;
				}
			}
		});
		return check;
	};

	// 判断   每个流算子必须至少有一条连接线。
	const checkHasOneLine = (sourceArr: string[], targetArr: string[]) => {
		const all = _.uniq([...sourceArr, ...targetArr]);
		if (all.length === operatorList.length) {
			return true;
		} else {
			return false;
		}
		// _.uniq([2, 1, 2]);
	};

	const handleCheck = () => {
		if (operatorList.length === 0) {
			!nullText && Message.error(nullText || "内容不能为空！");
			return nullText || "内容不能为空！";
		}
		let sourceArr: string[] = [];
		let targetArr: string[] = [];
		operatorList.forEach((flowNode) => {
			flowNode.edges.forEach((edge) => {
				edge.source && sourceArr.push(edge.source);
				edge.target && targetArr.push(edge.target);
			});
		});
		if (!checkHasOneLine([...sourceArr], [...targetArr])) {
			!nullText && Message.error("部分算子没有流程线，请检查流程！");
			return "部分算子没有流程线，请检查流程！";
		}
		if (!checkIn([...targetArr])) {
			!nullText &&
				Message.error("每个流程第一步需读取文件/数据集，请检查流程！");
			return "每个流程第一步需读取文件/数据集，请检查流程！";
		}
		if (!checkOut([...sourceArr])) {
			!nullText &&
				Message.error(
					"每个流程最后一步必须将数据写入为文件/数据集，请检查流程！"
				);
			return "每个流程最后一步必须将数据写入为文件/数据集，请检查流程！";
		}
		successCallBack();
		return "";
	};

	return { handleCheck };
};

export default useCheckOperator;
