import style from "./index.module.css";
import React, { useState, useEffect } from "react";
import LogView from "@/views/ResourceCenter/components/LogView";
import { useNavigate } from "react-router-dom";
import BasicInfo, {
	IInfoItem,
} from "@/views/ResourceCenter/components/BasinInfo";
import { getActorenvDetail } from "@/api/resourceCenter";
import useMyRequest from "@/hooks/useMyRequest";
import goback from "@/assets/project/goback.svg";
import { useLocation } from "react-router-dom";
import MyCircularProgress from "@/components/mui/MyCircularProgress";
import jobFail from "@/assets/project/jobFail.svg";
import jobRun from "@/assets/project/jobRun.svg";
import jobSue from "@/assets/project/jobSue.svg";

const SeeEnv = () => {
	const navigate = useNavigate();
	const location = useLocation();
	const [id, setId] = useState("");
	const [info, setInfo] = useState<any>({});
	const [infoListTop, setInfoListTop] = useState<Array<IInfoItem>>([
		{
			label: "构建状态",
			value: "",
		},
		{
			label: "创建时间",
			value: "",
		},
		{
			label: "构建时长",
			value: "",
		},
		{
			label: "构建成本",
			value: "",
		},
		{
			label: "基础环境",
			value: "",
		},
	]);
	const [infoListBot, setInfoListBot] = useState<Array<IInfoItem>>([
		{
			label: "描述",
			value: "",
		},
	]);
	const [logs, setLogs] = useState<Array<any>>([]);

	const getStatus = (item: any) => {
		if (item.status === "PENDING") {
			return (
				<span className={style.statusBox}>
					<img src={jobRun} alt="" />
					<span className={style.status}>准备构建</span>
				</span>
			);
		} else if (item.status === "CREATING") {
			return (
				<span className={style.statusBox}>
					<img src={jobRun} alt="" />
					<span className={style.status}>正在构建</span>
				</span>
			);
		} else if (item.status === "FAILED") {
			return (
				<span className={style.statusBox}>
					<img src={jobFail} alt="" />
					<span className={style.status}>构建失败</span>
				</span>
			);
		} else if (item.status === "CREATED") {
			return (
				<span className={style.statusBox}>
					<img src={jobSue} alt="" />
					<span className={style.status}>构建完成</span>
				</span>
			);
		} else {
			return "";
		}
	};

	const { run, loading } = useMyRequest(getActorenvDetail, {
		onSuccess: (res) => {
			setInfo(res.data);
			let data = res.data;
			setInfoListTop([
				{
					label: "构建状态",
					value: getStatus(data),
				},
				{
					label: "创建时间",
					value: data.createdTime,
				},
				{
					label: "构建时长",
					value: data.costTime,
				},
				{
					label: "构建成本",
					value: "￥" + data.feeCost,
				},
				{
					label: "基础环境",
					value: data.baseEnvName,
				},
			]);
			setInfoListBot([
				{
					label: "描述",
					value: data.desc,
				},
			]);
			setLogs(
				data.tasks
					.filter((task: any) => task.outLog)
					.map((task: any) => ({
						logName: `${task.title}.log`,
						logPath: task.outLog,
					}))
			);
		},
	});
	useEffect(() => {
		if (id) {
			run({ id });
		}
	}, [id, run]);
	useEffect(() => {
		const locationInfo: any = location?.state;
		console.log(locationInfo);
		setId(locationInfo.id);
	}, [location, setId]);

	return (
		<div className={style.seeEnv}>
			<MyCircularProgress loading={loading} />
			<div className={style.titleBox}>
				<img
					className={style.goBackIcon}
					src={goback}
					alt=""
					onClick={() =>
						navigate("/utility/resourceCenter/userResources", {
							state: { defaultTab: "USERRESOURCES_ENVIRONMENT" },
						})
					}
				/>
				<div className={style.title}>{info.title}</div>
				<div className={style.type}>
					{info.type === "BATCH" ? "批式环境" : "流式环境"}
				</div>
			</div>
			<div className={style.infoBox}>
				<div className={style.baseTitle}>基础信息</div>
				<div className={style.basicInfoBox}>
					<BasicInfo infoList={infoListTop} />
					<BasicInfo infoList={infoListBot} />
				</div>
			</div>
			<div className={style.logsBox}>
				<div className={style.logsTitle}>日志</div>
				<div className={style.LogViewBox}>
					{!loading && <LogView logs={logs}></LogView>}
				</div>
			</div>
		</div>
	);
};

export default SeeEnv;
