/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-11-01 14:49:40
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// 应用环境
import { useCallback, useEffect, useState } from "react";
import { observer } from "mobx-react";
import _ from "lodash";
import Add from "@mui/icons-material/Add";

import SearchInput from "@/components/BusinessComponents/SearchInput";
import MySelect from "@/components/mui/MySelect";
import MyButton from "@/components/mui/MyButton";
import OperatorCard from "./components/OperatorCard";
import AddOperator from "./components/AddOperator";
import CardTable from "@/components/CommonComponents/CardTable";
import { useStores } from "@/store";
import { getOperatorList, IOperatorListParams } from "@/api/resourceCenter";
import useMyRequest from "@/hooks/useMyRequest";
import { IOperatorInfo } from "./interface";

import styles from "./index.module.css";
import MyCircularProgress from "@/components/mui/MyCircularProgress";
import NoData from "@/components/BusinessComponents/NoData";

const WorkflowOperator = observer(() => {
	const [pageType, setPageType] = useState<string>("");
	/** 产品store */
	const { productListStore } = useStores();
	/**  算子列表参数 */
	const [searchParams, setSearchParams] = useState<IOperatorListParams>({
		keyword: "",
		productId: "all",
		type: "all",
	});

	/** 详情ID */
	const [detailsId, setDetailsId] = useState<string>("");
	/** 详情最大版本 */
	const [detailsMaxVersion, setDetailsMaxVersion] = useState<string>("");

	const [list, setList] = useState<IOperatorInfo[]>();

	const { run: getList, loading } = useMyRequest(getOperatorList, {
		// refreshDeps: [],
		onSuccess: (res) => {
			console.log(res);
			setList(res?.data.content);
		},
	});

	const newGetList = useCallback(() => {
		const params = _.cloneDeep(searchParams);
		if (params.productId === "all") {
			params.productId = "";
		}
		if (params.type === "all") {
			params.type = "";
		}
		getList({ ...params });
	}, [getList, searchParams]);

	// 按回车搜索
	const handleKeyWordChangeKeyUp = (e: any) => {
		if (e.keyCode === 13) {
			newGetList();
		}
	};

	useEffect(() => {
		newGetList();
	}, [searchParams.productId, searchParams.type]);

	return (
		<div>
			<div className={styles.indexBox}>
				<div className={styles.headerBox}>
					<div>
						<SearchInput
							sx={{ width: 340, marginRight: "16px" }}
							value={searchParams.keyword}
							onKeyUp={handleKeyWordChangeKeyUp}
							onChange={(e) => {
								setSearchParams({ ...searchParams, keyword: e.target.value });
							}}
						/>
						<MySelect
							options={
								[
									{ label: "全部产品", value: "all" },
									...productListStore?.productList,
								] || []
							}
							value={searchParams.productId}
							onChange={(e) => {
								setSearchParams({ ...searchParams, productId: e });
							}}
							className={styles.searchSelectBox}
							sx={{ width: "150px", height: "32px" }}
						/>
						<MySelect
							value={searchParams.type}
							onChange={(e) => {
								setSearchParams({ ...searchParams, type: e });
							}}
							options={[
								{ label: "全部环境", value: "all" },
								{
									label: "批式",
									value: "BATCH",
								},
								{
									label: "流式",
									value: "FLOW",
								},
							]}
							sx={{ width: "150px", height: "32px" }}
						/>
					</div>
					<MyButton
						text="构建算子"
						startIcon={<Add />}
						onClick={() => {
							setPageType("add");
							setDetailsId("");
							setDetailsMaxVersion("");
						}}
					></MyButton>
				</div>
				<MyCircularProgress loading={loading}>
					{list?.length ? (
						<div className={styles.contentBox}>
							<CardTable
								data={list}
								renderItem={(item: any) => (
									<OperatorCard
										setDetailsId={setDetailsId}
										setDetailsMaxVersion={setDetailsMaxVersion}
										operatorInfo={item}
										setPageType={setPageType}
									/>
								)}
								itemMinWidth={377}
							></CardTable>
						</div>
					) : (
						<div className={styles.noDataHeight}>
							<NoData text="暂无工作流算子"></NoData>
						</div>
					)}
				</MyCircularProgress>
			</div>
			{pageType && (
				<AddOperator
					getList={newGetList}
					detailsId={detailsId}
					detailsMaxVersion={detailsMaxVersion}
					setPageType={setPageType}
					pageType={pageType}
				/>
			)}
		</div>
	);
});

export default WorkflowOperator;
