import { useEffect, useState, useRef } from "react";
import MyCircularProgress from "@/components/mui/MyCircularProgress";
import { List } from "react-virtualized";

interface IVirtuallyListProps {
	list: Array<any>;
	renderRow: any;
	rowHeight: Number | Function;
	listStyle?: Object;
	loading?: boolean;
	onScroll?: Function;
}

const VirtuallyList = (props: IVirtuallyListProps) => {
	const {
		list,
		renderRow,
		rowHeight,
		listStyle,
		loading = false,
		onScroll,
	} = props;

	const [width, setWidth] = useState(0);
	const [height, setHeight] = useState(0);

	const virtuallyListBoxRef: any = useRef(null);

	const getTableWidthHeight = () => {
		setWidth(virtuallyListBoxRef?.current?.offsetWidth || 1000);
		setHeight(virtuallyListBoxRef?.current?.offsetHeight || 300);
	};

	useEffect(() => {
		getTableWidthHeight();
	}, []);

	window.onresize = () => {
		getTableWidthHeight();
	};

	return (
		<div
			ref={virtuallyListBoxRef}
			style={{ width: "100%", height: "100%", position: "relative" }}
		>
			<MyCircularProgress loading={loading} />
			<List
				width={width}
				height={height}
				rowCount={list.length}
				rowHeight={rowHeight}
				rowRenderer={renderRow}
				overscanRowCount={20}
				style={listStyle}
				onScroll={onScroll}
			/>
		</div>
	);
};
export default VirtuallyList;
