import MyMuiTable from "./MyMuiTable";
import VirtuallyTable from "../CommonComponents/VirtuallyTable";

type Order = "ASC" | "DESC"; // 升序为asc，降序为desc。

export type sortState = {
	field: string | null | undefined | ""; // 根据哪个属性来排序
	order: Order | null | undefined | "";
};

interface IMyTableProps {
	isVirtuallyTable?: boolean; // 是不是虚拟表格
	rows: Array<any>; // 表格数据
	headCells: Array<any>; // 表头配置
	tableKey?: string; // 表格数据的key
	loading?: boolean; // 是否正在加载数据
	hasCheckbox?: boolean; // 是否有复选框
	selectItems?: Array<any>; // 选中的项
	setSelectItems?: any; // 设置选中的项
	fixedHead?: boolean; // 是否是固定表头
	noDataText?: string; // 无数据提示文案
	hasTableFooter?: boolean; // 是否有分页组件
	page?: number; // 当前页
	pageChange?: any; // 页码改变
	count?: number; // 总页数
	totalElements?: number; // 数据总量 不止是列表渲染的长度
	sortState?: sortState; // 排序状态
	setSortState?: any; // 设置排序状态
	paginationType?: "simple" | "complex"; // 分页组件的类型   simple简洁式  complex复杂、带每页数量切换、总数等
	rowsPerPage?: number; // 每页多少条数据
	handleChangeRowsPerPage?: any; // 每页多少条数据变化
	nodataText?: any; // 无数据文案
	handleRow?: any; // 点击一行
	activeId?: string; // 选中的一行的id
	disableFn?: any; // 禁用时根据disableFn来判断是否禁用
}

const MyTable = (props: IMyTableProps) => {
	const {
		isVirtuallyTable = false,
		rows,
		headCells,
		tableKey = "id",
		loading = false,
		hasCheckbox = false,
		selectItems = [],
		setSelectItems,
		fixedHead,
		hasTableFooter = false,
		page = 0,
		pageChange = () => {},
		count = 1,
		sortState,
		setSortState,
		paginationType = "simple",
		rowsPerPage = 10,
		handleChangeRowsPerPage,
		totalElements = 0,
		nodataText,
		handleRow,
		activeId,
		disableFn,
	} = props;

	if (!isVirtuallyTable) {
		return (
			<MyMuiTable
				rows={rows}
				headCells={headCells}
				tableKey={tableKey}
				loading={loading}
				hasCheckbox={hasCheckbox}
				selectItems={selectItems}
				setSelectItems={setSelectItems}
				fixedHead={fixedHead}
				hasTableFooter={hasTableFooter}
				page={page}
				pageChange={pageChange}
				count={count}
				sortState={sortState}
				setSortState={setSortState}
				paginationType={paginationType}
				rowsPerPage={rowsPerPage}
				handleChangeRowsPerPage={handleChangeRowsPerPage}
				totalElements={totalElements}
				nodataText={nodataText}
				handleRow={handleRow}
				activeId={activeId}
				disableFn={disableFn}
			></MyMuiTable>
		);
	} else {
		return (
			<VirtuallyTable
				rows={rows}
				headCells={headCells}
				tableKey={tableKey}
				loading={loading}
				hasCheckbox={hasCheckbox}
				selectItems={selectItems}
				setSelectItems={setSelectItems}
				sortState={sortState}
				setSortState={setSortState}
				nodataText={nodataText}
				handleRow={handleRow}
				activeId={activeId}
				disableFn={disableFn}
			></VirtuallyTable>
		);
	}
};

export default MyTable;
