/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-17 16:16:42
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useCallback } from "react";
import { isEqual } from "lodash";
import { useState } from "react";
import { Box } from "@mui/system";
import Tab from "@mui/material/Tab";
import { ThemeProvider, createTheme } from "@mui/material/styles";
import { TabContext, TabList, TabPanel } from "@mui/lab";
import { Typography } from "@mui/material";
import classNames from "classnames";
import { useNavigate } from "react-router-dom";

import styles from "./index.module.css";

interface ITabList {
	label: string;
	value: string;
	component: JSX.Element | React.ReactNode;
	icon?: string;
	iconed?: string;
	iconHover?: string;
	hide?: boolean;
	disabled?: boolean;
}

interface IProps {
	/** 标题 */
	title?: string;
	/** title样式class */
	titleClass?: any;
	/** 选中值 */
	value?: string;
	/** 值 */
	onChange?: (val: string) => void;
	/** tab页面数组 */
	tabList: ITabList[];
	/**  默认选中tab */
	defaultValue?: string;
	/**  面板样式 */
	tabPanelSx?: any;
	/**   是否允许空值 */
	allowNullValue?: boolean;
	/**   路由地址  配合navigate和MyTabs组件的defaultValue组合使用、F5刷新也可以保存激活的tab */
	navigateUrl?: string;
}

const theme = createTheme({
	components: {
		MuiTab: {
			styleOverrides: {
				root: {
					paddingLeft: 0,
					paddingRight: 0,
					paddingTop: "8px",
					paddingBottom: "8px",
					minWidth: "20px",
					marginRight: "32px",
					color: "#8A9099",
					":hover": {
						color: "#1E2633",
					},
					selected: {
						color: "#1976d2",
					},
					"&.Mui-disabled": {
						color: "#C2C6CC",
					},
				},
			},
		},
		MuiTabs: {
			styleOverrides: {
				indicator: {
					backgroundColor: "#1370FF",
				},
				flexContainer: {
					alignItems: "center",
				},
			},
		},
		MuiButtonBase: {
			styleOverrides: {
				root: {
					"&.Mui-selected .MuiTypography-root": {
						fontWeight: "600",
					},
				},
			},
		},
	},
});

const Tabs = (props: IProps) => {
	const {
		tabList,
		value,
		defaultValue,
		onChange,
		allowNullValue = false,
		tabPanelSx = { padding: "20px 0 0 0" },
		title,
		titleClass,
		navigateUrl,
	} = props;

	const navigate = useNavigate();

	const [tabValue, setTabValue] = useState(
		defaultValue
			? defaultValue
			: allowNullValue
			? ""
			: tabList.filter((e) => !e.hide)[0].value
	);

	const [hoverValue, setHoverValue] = useState("");

	const onTabChange = (val: string) => {
		setTabValue(val);
		onChange && onChange(val);
		navigateUrl &&
			navigate(navigateUrl, {
				state: { defaultTab: val },
			});
	};

	const getImgSrc = useCallback(
		(item: ITabList) => {
			let result = item.icon;
			if (value === item.value || tabValue === item.value) {
				result = item.iconed;
			}
			if (hoverValue === item.value) {
				result = item.iconHover;
			}
			return result;
		},
		[hoverValue, value, tabValue]
	);

	const labelRender = (item: ITabList, key: number) => {
		return (
			<div
				style={{ display: "flex", alignItems: "center" }}
				onMouseOver={() => setHoverValue(item.value)}
				onMouseOut={() => setHoverValue("")}
			>
				{item.icon ? (
					<img
						style={{ width: "16px", marginRight: "8px" }}
						src={getImgSrc(item)}
						alt=""
					/>
				) : (
					""
				)}
				<Typography
					sx={{
						fontSize: "14px",
						lineHeight: "22px",
						height: "22px",
						fontWeight: "400",
					}}
				>
					{item.label}
				</Typography>
			</div>
		);
	};

	return (
		<ThemeProvider theme={theme}>
			<TabContext value={value || tabValue}>
				<Box sx={{ borderBottom: 1, borderColor: "#EDEFF2" }}>
					<TabList
						onChange={(e: any, val: string) => {
							onTabChange(val);
						}}
					>
						{title ? (
							<span
								className={classNames({
									[styles.titleBox]: true,
									[titleClass]: titleClass,
								})}
							>
								{title}
							</span>
						) : null}
						{title ? <div className={styles.titleBoxLine}></div> : null}
						{tabList
							?.filter((item) => !item.hide)
							.map((item, key) => {
								return (
									<Tab
										key={key}
										label={labelRender(item, key)}
										value={item.value || ""}
										id={item.value}
										disabled={item.disabled}
									/>
								);
							})}
					</TabList>
				</Box>
				{tabList
					?.filter((item) => !item.hide)
					.map((item) => {
						return (
							<TabPanel
								sx={tabPanelSx}
								value={item.value || ""}
								key={item.value}
							>
								{item.component}
							</TabPanel>
						);
					})}
			</TabContext>
		</ThemeProvider>
	);
};
const handleEqual = (prvProps: IProps, nextProps: IProps) => {
	if (isEqual(prvProps, nextProps)) {
		return true;
	}
	return false;
};

export default memo(Tabs, handleEqual);
