/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-27 18:09:14
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-27 18:19:06
 * @FilePath: /bkunyun/src/views/CustomOperator/utils.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import _ from "lodash";

import { ITask } from "../Project/ProjectSubmitWork/interface";

// 坐标转换
const positionTransform = (operatorList: ITask[]) => {
	const copyOperatorList: ITask[] = _.cloneDeep(operatorList);
	const positionXArr = copyOperatorList.map((operatorLi) => {
		return operatorLi.position.x;
	});
	const positionYArr = copyOperatorList.map((operatorLi) => {
		return operatorLi.position.y;
	});
	let minPositionX = Math.min(...positionXArr);
	let minPositionY = Math.min(...positionYArr);
	let startingPointX = minPositionX - 40;
	let startingPointY = minPositionY - 10;
	return copyOperatorList.map((operatorLi) => {
		return {
			...operatorLi,
			position: {
				x: operatorLi.position.x - startingPointX,
				y: operatorLi.position.y - startingPointY,
			},
		};
	});
};

export default positionTransform;
