/*
 * @Author: rocosen
 * @Date: 2022-06-12 10:05:13
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-17 15:36:38
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useMemo } from "react";
import { Box } from "@mui/system";
import { observer } from "mobx-react-lite";
import { useLocation } from "react-router-dom";
import { useStores } from "@/store/index";

import WorkbenchTemplate from "./workbenchTemplate";
import WorkbenchList from "./workbenchList";
import Tabs from "@/components/mui/MyTabs";
import usePass from "@/hooks/usePass";
import NoProject from "@/components/BusinessComponents/NoProject";
import Template from "@/assets/project/workbenchTemplate.svg";
import TemplateSelect from "@/assets/project/workbenchTemplate_select.svg";
import TemplateHover from "@/assets/project/workbenchTemplate_hover.svg";
import List from "@/assets/project/workbenchList.svg";
import ListHover from "@/assets/project/workbenchList_hover.svg";
import ListSelect from "@/assets/project/workbenchList_select.svg";

const ProjectWorkbench = observer(() => {
	const { currentProjectStore } = useStores();
	const isPass = usePass();
	const location: any = useLocation();

	const tabList = useMemo(() => {
		return [
			{
				label: "工作流模版",
				value: "workbenchTemplate",
				component: <WorkbenchTemplate />,
				hide: !isPass("PROJECT_WORKBENCH_FLOES"),
				icon: Template,
				iconed: TemplateSelect,
				iconHover: TemplateHover,
			},
			{
				label: "任务列表",
				value: "workbenchList",
				component: <WorkbenchList />,
				hide: !isPass("PROJECT_WORKBENCH_JOBS"),
				icon: List,
				iconed: ListSelect,
				iconHover: ListHover,
			},
		];
	}, [isPass]);
	if (currentProjectStore.currentProjectInfo.name) {
		return (
			<div style={{ padding: "22px 24px 24px" }}>
				<div style={{ display: "flex", alignItems: "center" }}>
					<span
						style={{
							fontSize: "18px",
							lineHeight: "26px",
							fontWeight: "600",
							color: "#1E2633",
							marginBottom: "-1px",
						}}
					>
						工作台
					</span>
				</div>
				<Box sx={{ width: "100%", typography: "body1" }}>
					<Tabs
						tabList={tabList}
						defaultValue={location?.state?.type || "workbenchTemplate"}
					/>
				</Box>
			</div>
		);
	} else {
		return <NoProject />;
	}
});

export default memo(ProjectWorkbench);
