import { memo } from "react";
import { Box, Typography } from "@mui/material";
import MyDialog from "@/components/mui/MyDialog";

const SimpleDialog = (props: any) => {
	const { openDialog, closeDialog, onConfirm, text, title } = props;

	return (
		<>
			<MyDialog
				open={openDialog}
				onClose={closeDialog}
				onConfirm={onConfirm}
				title={title}
				okColor="error"
				isText={true}
			>
				<Box>
					<Typography sx={{ fontSize: "14px", fontWeight: "400" }}>
						{text}
					</Typography>
				</Box>
			</MyDialog>
		</>
	);
};

export default memo(SimpleDialog);
