import MyTableDemo from "./MyTableDemo";
import QueueSelectDemo from "./QueueSelectDemo";
import IconfontDemo from "./IconfontDemo";
import CardTableDemo from "./CardTableDemo";
import VirtuallyListDemo from "./VirtuallyListDemo";
import VirtuallyTableDemo from "./VirtuallyTableDemo";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import { useState } from "react";
import styles from "./index.module.css";

const Demo = () => {
	const radioOptionsArr = [
		{
			value: "virtuallyTableDemo",
			label: "virtuallyTableDemo",
		},
		{
			value: "virtuallyListDemo",
			label: "virtuallyListDemo",
		},
		{
			value: "cardTable",
			label: "cardTable/virtuallyCardTable",
		},
		{
			value: "iconfont",
			label: "iconfont",
		},
		{
			value: "队列选择器",
			label: "队列选择器",
		},
		{
			value: "表格",
			label: "表格",
		},
		{
			value: "box",
			label: "box",
		},
	];
	const handleRadio = (e: string) => {
		setSelectDemo(e);
	};
	const [selectDemo, setSelectDemo] = useState("virtuallyListDemo");

	return (
		<div className={styles.demoBox}>
			<RadioGroupOfButtonStyle
				value={selectDemo}
				radioOptions={radioOptionsArr}
				handleRadio={handleRadio}
			/>
			<div className={styles.demoContentBox}>
				{selectDemo === "virtuallyListDemo" && (
					<VirtuallyListDemo></VirtuallyListDemo>
				)}
				{selectDemo === "virtuallyTableDemo" && (
					<VirtuallyTableDemo></VirtuallyTableDemo>
				)}
				{selectDemo === "cardTable" && <CardTableDemo></CardTableDemo>}
				{selectDemo === "iconfont" && <IconfontDemo></IconfontDemo>}
				{selectDemo === "队列选择器" && <QueueSelectDemo></QueueSelectDemo>}
				{selectDemo === "表格" && <MyTableDemo></MyTableDemo>}
				{selectDemo === "box" && <div>box</div>}
			</div>
		</div>
	);
};

export default Demo;
