package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.dto.UserVpsDto;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import static org.springframework.data.mongodb.core.query.Criteria.where;

/**
 * @author xuxin
 * @date 2020/8/24 14:08
 * @description
 */
public class UserVpsRepositoryCustomImpl implements UserVpsRepositoryCustom {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public boolean deleteVpsIdOfUserVpsList(String id, String vpsId) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").is(id));
        Update update = new Update();
        update.pull("vpsIdList", vpsId);
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, UserVpsDto.class);
        return result.getModifiedCount() >= 1;

    }
}
