package com.edgec.browserbackend.browser.service.Impl;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.browser.ErrorCode.VpsErrorCode;
import com.edgec.browserbackend.browser.domain.Vps;
import com.edgec.browserbackend.browser.dto.AssignVpsDto;
import com.edgec.browserbackend.browser.dto.UserVpsDto;
import com.edgec.browserbackend.browser.repository.UserVpsRepository;
import com.edgec.browserbackend.browser.repository.VpsRepository;
import com.edgec.browserbackend.browser.service.VpsService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.utils.BeanUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author xuxin
 * @date 2020/8/13 11:45
 * @description
 */
@Slf4j
@Service
public class VpsServiceImpl implements VpsService {
    @Autowired
    private VpsRepository vpsRepository;

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private UserVpsRepository userVpsRepository;

    private static String rdpString = "screen mode id:i:2\n" +
            "use multimon:i:0\n" +
            "desktopwidth:i:1920\n" +
            "desktopheight:i:1080\n" +
            "session bpp:i:32\n" +
            "winposstr:s:0,1,96,127,1920,1001\n" +
            "compression:i:1\n" +
            "keyboardhook:i:2\n" +
            "audiocapturemode:i:0\n" +
            "videoplaybackmode:i:1\n" +
            "connection type:i:7\n" +
            "networkautodetect:i:1\n" +
            "bandwidthautodetect:i:1\n" +
            "displayconnectionbar:i:1\n" +
            "enableworkspacereconnect:i:0\n" +
            "disable wallpaper:i:0\n" +
            "allow font smoothing:i:0\n" +
            "allow desktop composition:i:0\n" +
            "disable full window drag:i:1\n" +
            "disable menu anims:i:1\n" +
            "disable themes:i:0\n" +
            "disable cursor setting:i:0\n" +
            "bitmapcachepersistenable:i:1\n" +
            "full address:s:#VPS_IP#\n" +
            "audiomode:i:0\n" +
            "redirectprinters:i:1\n" +
            "redirectcomports:i:0\n" +
            "redirectsmartcards:i:1\n" +
            "redirectclipboard:i:1\n" +
            "redirectposdevices:i:0\n" +
            "autoreconnection enabled:i:1\n" +
            "authentication level:i:2\n" +
            "prompt for credentials:i:0\n" +
            "negotiate security layer:i:1\n" +
            "remoteapplicationmode:i:0\n" +
            "alternate shell:s:\n" +
            "shell working directory:s:\n" +
            "gatewayhostname:s:\n" +
            "gatewayusagemethod:i:4\n" +
            "gatewaycredentialssource:i:4\n" +
            "gatewayprofileusagemethod:i:0\n" +
            "promptcredentialonce:i:0\n" +
            "gatewaybrokeringtype:i:0\n" +
            "use redirection server name:i:0\n" +
            "rdgiskdcproxy:i:0\n" +
            "kdcproxyname:s:\n" +
            "drivestoredirect:s:C:\\:s:D:\\\n" +
            "username:s:#VPS_USER#\n" +
            "password 51:b:#VPS_PASSWORD#\n";

    @Override
    public String addVps(Vps vps) {
        Optional<Account> byId = accountRepository.findById(vps.getOwner1());
        String parent = null;
        if (byId.isPresent()) {
            parent = byId.get().getParent();
        }
        if (!StringUtils.isEmpty(parent)) {
            vps.setOwner2(parent);
        }
        vps.setCreateTime(Instant.now().toEpochMilli());
        Vps save = vpsRepository.save(vps);
        return save.getId();
    }

    @Override
    public void deleteVps(String userId, String vpsId) {
        Vps vps = vpsRepository.findById(vpsId).orElseThrow(() -> new ClientRequestException(VpsErrorCode.VPS_NOT_EXIST));
        if (userId.equals(vps.getOwner1()) || userId.equals(vps.getOwner2())) {
            vpsRepository.deleteById(vpsId);
        }

        // 删除与当前 vps 相关的 分配信息
        List<String> userIds = accountRepository.findIdsByParentId(userId);

        // 移除账户列表中的 vps 的创建者 与 父用户
        userIds.remove(vps.getOwner1());
        userIds.remove(vps.getOwner2());
        userIds.forEach(
                // 删除 UserVpsDto 中 UserVpsList 分配的 vpsId
                userId1 -> userVpsRepository.deleteVpsIdOfUserVpsList(userId1, vpsId)
        );
    }

    @Override
    public void updateVps(Vps vps) {
        Vps destination = vpsRepository.findById(vps.getId()).orElseThrow(() -> new ClientRequestException(VpsErrorCode.VPS_NOT_EXIST));
        vps.setId(null);
        BeanUtils.mergeObject(vps, destination);
        vpsRepository.save(destination);
    }

    @Override
    public String loginVps(String id) {
        Vps vps = vpsRepository.findById(id).orElseThrow(() -> new ClientRequestException(VpsErrorCode.VPS_NOT_EXIST));
        return rdpString.replace("#VPS_IP#", vps.getVpsIp()).replace("#VPS_USER#", vps.getVpsUser()).replace("#VPS_PASSWORD#", vps.getVpsPassword()) + "shopname:" + vps.getVpsShopName();
    }

    @Override
    public Page<Vps> queryPage(String userId, Pageable pageable) {
        // 1. 获取属于当前创建的 vps
        List<String> ids = new ArrayList<>(vpsRepository.findByOwner1OrOwner2(userId, userId).stream().map(Vps::getId).collect(Collectors.toList()));

        // 2. 获取分配给当前登录用户的vps
        UserVpsDto userVpsDto = userVpsRepository.findById(userId).orElse(null);
        if (userVpsDto != null) {
            ids.addAll(userVpsDto.getVpsIdList());
        }

        Page<Vps> page = vpsRepository.findByIdInOrderByCreateTimeDesc(ids, pageable);

        /*// 由于在删除vps的时候，没有在分配的账户中删除对应的 vps。所以需要在这里进行惰性删除
        List<String> list = page.getContent().stream().map(Vps::getId).collect(Collectors.toList());
        if (userVpsDto != null) {
            userVpsDto.getVpsIdList().removeAll(list);
            userVpsRepository.save(userVpsDto);
        }*/
        return page;
    }

    @Override
    public void assignVpsList(String userId, AssignVpsDto assignVpsDto) {
        Optional<Account> byId = accountRepository.findById(userId);
        String parent = null;
        if (byId.isPresent()) {
            parent = byId.get().getParent();
        }
        if (!StringUtils.isEmpty(parent)) {
            throw new ClientRequestException(VpsErrorCode.VPS_NOT_ACCESS);
        }

        // 分配前，先删除之前的分配信息
        // 1. 获取当前用户的所有关联账户（自身+子账户）
        List<String> ids = accountRepository.findIdsByParentId(userId);
        Iterable<Vps> vpsIter = vpsRepository.findAllById(assignVpsDto.getVpsIds());
        Iterator<Vps> iterator = vpsIter.iterator();
        while (iterator.hasNext()) {
            List<String> currentIds = new ArrayList<>();
            currentIds.addAll(ids);
            Vps next = iterator.next();
            // 移除账户列表中的 vps 的创建者 与 父用户
            currentIds.remove(next.getOwner1());
            currentIds.remove(next.getOwner2());
            currentIds.forEach(
                    // 删除 UserVpsDto 中 UserVpsList 分配的 vpsId
                    userId1 -> userVpsRepository.deleteVpsIdOfUserVpsList(userId1, next.getId())
            );
        }

        List<UserVpsDto> list = new ArrayList<>();
        for (String id : assignVpsDto.getUserIds()) {
            UserVpsDto uv = new UserVpsDto(id, assignVpsDto.getVpsIds());
            list.add(uv);
        }
        userVpsRepository.saveAll(list);
    }

    @Override
    public List<String> queryAssignUserList(String user, String vpsId) {
        Vps vps = vpsRepository.findByIdAndOwner1AndOwner2(vpsId, user, null).orElseThrow(() -> new ClientRequestException(VpsErrorCode.VPS_NOT_EXIST));
        return userVpsRepository.findByUserIdLikeAndVpsIdListIn(user, vps.getId()).stream().map(UserVpsDto::getUserId).collect(Collectors.toList());
    }
}
