package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.account.domain.User;
import com.edgec.browserbackend.account.domain.UserPayment;
import com.edgec.browserbackend.browser.domain.Group;
import com.edgec.browserbackend.browser.domain.UserShop;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import static org.springframework.data.mongodb.core.query.Criteria.where;

public class UserShopRepositoryCustomImpl implements UserShopRepositoryCustom {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public boolean deleteByUsernameAndShopId(String username, String shopId) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("username").is(username).and("shopId").is(shopId));
        DeleteResult operation = mongoTemplate.remove(basicQuery, UserShop.class);
        if (operation.getDeletedCount() < 1)
            return false;
        else
            return true;
    }

    @Override
    public void updateGroupId(String groupId_old, String groupId_new) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("groupId").is(groupId_old));
        Update update = new Update();
        update.set("groupId", groupId_new);
        mongoTemplate.updateFirst(basicQuery, update, UserShop.class);
    }

    @Override
    public boolean deleteByShopIdExceptOwner(String shopId, String owner) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("shopId").is(shopId).and("username").ne(owner));
        DeleteResult operation = mongoTemplate.remove(basicQuery, UserShop.class);
        if (operation.getDeletedCount() < 1)
            return false;
        else
            return true;
    }
}
