package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@Document(collection = "userprepaidbilling")
@JsonIgnoreProperties(ignoreUnknown = true)
@CompoundIndex(name = "idx_username_timestamp", def = "{'username': 1, 'timestamp': 1}")
public class UserPrePaidBilling {

    @Id
    private String id;

    private String username;

    private String tradeNo;

    private int year;

    private int month;

    private long timestamp;

    private Services services = Services.ECC;

    private float rate;

    private int amount;

    private int period;

    private BillStatus status;

    /**
     * 0 -- 余额, 1 -- 支付宝, 2 -- 微信, 3 -- 银行转账
     */
    private int payMethod;

    private boolean isPrepaid;

    /**
     * 本次消费金额
     */
    private float total;

    /**
     * 0 -- 充值, 1 -- newip, 2 -- renew, 3 -- return, 4 -- 礼金提现
     */
    private int chargeType;

    private String unit = "month";

    private String administrator;

    private float balanced;

    /**
     * 购买或者续费的ip 号
     */
    private String chargeIp;

    private List<DeductionRecord> deductionRecords = new ArrayList<>();

    public void addDeductionRecord(DeductionRecord record) {
        this.deductionRecords.add(record);
    }

}
