package com.edgec.browserbackend.browser.dto;

import com.edgec.browserbackend.browser.domain.BindHistory;
import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.domain.IpType;
import com.edgec.browserbackend.browser.domain.Vendor;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
public class IpResourceUnwindResultDto {
    private String id;
    private String addr;
    private IpType ipType = IpType.VENDOR;
    private Vendor vendor;
    private String vendorCn;
    private String region;
    private String regionCn;
    //0:正常, 1:已过期, 2:即将过期, 3:正在分配, 4:未使用, 5:已失效, 6:未分配, 7:未缴费, 8:分配成功
    private int status;
    private List<String> port;
    private long purchasedTime;
    private long validTime;
    private String details;
    private List<BindHistory> bindHistory = new ArrayList<>();
    private boolean isDeleted;
    private String username;
    private String owner;
    private String userParent;
    private List<String> protocol;
    private String password;
    private double price;

    private boolean specialLine; //是否使用专线
    private boolean usingSpecialLine; //是否正在使用专线
    //专线数据
    private String proxyUsername; //专线的代理用户名
    private String proxyPassword; //专线的代理密码

    private String shopId;

    /**
     * 对应 IpResource 中 shopIds 的展开字段
     */
    private String shopIds;


    private boolean bind;

    private boolean isLocked;
    private long lockTimestamp;
    private long healthLockTimestamp;

    private String unit;
    private int period;


    public IpResource toResource() {
        IpResource ipResource = new IpResource();
        ipResource.setId(getId());

        if (!StringUtils.isEmpty(getShopIds())) {
            ipResource.setShopId(getShopIds());
            ipResource.getShopIds().add(getShopIds());
        }

        ipResource.setHealthLockTimestamp(getHealthLockTimestamp());
        ipResource.setUsingSpecialLine(isUsingSpecialLine());
        ipResource.setPeriod(getPeriod());
        ipResource.setSpecialLine(isSpecialLine());
        if (addr != null) {
            ipResource.setAddr(getAddr());
        }

        ipResource.setStatus(getStatus());
        if (proxyPassword != null) {
            ipResource.setProxyPassword(getProxyPassword());
        }

        if (proxyUsername != null) {
            ipResource.setProxyUsername(getProxyUsername());
        }

        ipResource.setLockTimestamp(getLockTimestamp());
        if (username != null) {
            ipResource.setUsername(getUsername());
        }

        if (regionCn != null) {
            ipResource.setRegionCn(getRegionCn());
        }

        if (vendorCn != null) {
            ipResource.setVendorCn(getVendorCn());
        }

        if (password != null) {
            ipResource.setPassword(getPassword());
        }

        if (unit != null) {
            ipResource.setUnit(getUnit());
        }

        ipResource.setLocked(isLocked());
        ipResource.setValidTime(getValidTime());
        if (bindHistory != null) {
            ipResource.setBindHistory(getBindHistory());
        }

        ipResource.setDeleted(isDeleted());
        if (owner != null) {
            ipResource.setOwner(getOwner());
        }

        if (protocol != null) {
            ipResource.setProtocol(getProtocol());
        }

        if (userParent != null) {
            ipResource.setUserParent(getUserParent());
        }

        ipResource.setPurchasedTime(getPurchasedTime());
        ipResource.setIpType(getIpType());
        if (port != null) {
            ipResource.setPort(getPort());
        }

        ipResource.setPrice(getPrice());
        if (details != null) {
            ipResource.setDetails(getDetails());
        }

        return ipResource;
    }
}
