package com.edgec.browserbackend.browser.service.Impl;

import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.domain.UserCode;
import com.edgec.browserbackend.browser.repository.IpResourceRepository;
import com.edgec.browserbackend.browser.repository.UserCodeRepository;
import com.edgec.browserbackend.browser.service.TempService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 *
 */
@Slf4j
@Service
public class TempServiceImpl implements TempService {
    @Autowired
    private UserCodeRepository userCodeRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Override
    public void save(UserCode userCode) {
        userCodeRepository.save(userCode);
    }

    @Override
    public void saveIpResource(String addr, String flag) {
        IpResource ipResource = ipResourceRepository.findByAddr(addr);

        if ("true".equals(flag)) {
            ipResource.setSpecialLine(true);
        }

        if ("false".equals(flag)) {
            ipResource.setSpecialLine(false);
        }

        ipResourceRepository.save(ipResource);
        log.info("ip地址为：" + addr + "专线状态更改为：" + flag);
    }
}
