package com.edgec.browserbackend.auth.service.security;


import com.edgec.browserbackend.auth.domain.User;
import com.edgec.browserbackend.auth.domain.UserAttemptsLogin;
import com.edgec.browserbackend.auth.exception.AuthErrorCode;
import com.edgec.browserbackend.auth.repository.UserAttemptsLoginRepository;
import com.edgec.browserbackend.auth.repository.UserRepository;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationSuccessEventListener implements ApplicationListener<AuthenticationSuccessEvent> {

    @Autowired
    private UserRepository userRepository;

    @Autowired
    private UserAttemptsLoginRepository userAttemptsLoginRepository;

    @Override
    public void onApplicationEvent(AuthenticationSuccessEvent authenticationSuccessEvent) {
        if (!authenticationSuccessEvent.getAuthentication().getDetails().toString().contains("remoteAddress")) {
            String username = authenticationSuccessEvent.getAuthentication().getName();
            User user = userRepository.findById(username).orElse(null);
            if (user != null) {
                UserAttemptsLogin userAttempts = userAttemptsLoginRepository.findById(username).orElse(null);
                if (userAttempts != null) {
                    if (userAttempts.getAttempts() >= 20) {
                        if (userAttempts.getDate().getTime() >= (System.currentTimeMillis() - 600000))
                            throw new ClientRequestException(AuthErrorCode.LOGINTIMESEXCEEDED, "Login times exceeded");
                    } else if (userAttempts.getAttempts() != 0) {
                        saveUserAttemptsLogin(username, 0);
                    }
                }
            }
        }
    }

    public void saveUserAttemptsLogin(String username, int attempts) {
        UserAttemptsLogin newUserAttempsLogin = new UserAttemptsLogin(username, attempts);
        userAttemptsLoginRepository.save(newUserAttempsLogin);
    }
}
