package com.edgec.browserbackend.browser.controller;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.dto.IpListRequestDto;
import com.edgec.browserbackend.browser.dto.IpPageResultDto;
import com.edgec.browserbackend.browser.dto.IpResourceRequestDto;
import com.edgec.browserbackend.browser.dto.IpResourceUpdateDto;
import com.edgec.browserbackend.browser.service.IpResourceService;
import com.edgec.browserbackend.common.auth.Securitys;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/ip")
public class IpControlloer {

    @Autowired
    private IpResourceService ipResourceService;

    /**
     * 购买IP资源
     */
    @RequestMapping(value = "/buy", method = RequestMethod.POST)
    public ResultDto buyIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            List<String> ipResourceDto = ipResourceService.buyIp(principal.getName(), ipResourceRequestDto);
            resultDto.setData(ipResourceDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/renew", method = RequestMethod.POST)
    public ResultDto renewIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(ipResourceService.renewIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     * 删除指定IP资源
     */
    @RequestMapping(value = "/del", method = RequestMethod.POST)
    public ResultDto deleteIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(ipResourceService.deleteIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    public ResultDto getIpList(Principal principal, @RequestBody IpListRequestDto ipListRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            IpPageResultDto ipResourceDto = ipResourceService.getIpList(principal.getName(), ipListRequestDto.getGroupType(), ipListRequestDto.getPage(),
                    ipListRequestDto.getAmount(), ipListRequestDto.getFilter());
            resultDto.setData(ipResourceDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }


    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultDto updateIp(Principal principal, @RequestBody IpResourceUpdateDto ipResourceUpdateDto) {
        ResultDto resultDto = new ResultDto();
        try {
            ipResourceService.updateIp(principal.getName(), ipResourceUpdateDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode().getCode());
            statusInfo.put("message", e.getErrorCode().getReason());
            resultDto.setStatusInfo(statusInfo);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/query", method = RequestMethod.POST)
    public ResultDto queryIp(Principal principal, @RequestBody IpResourceUpdateDto ipResourceUpdateDto) {
        ResultDto resultDto = new ResultDto();
        try {
            HashMap<String, Boolean> map = new HashMap<>();
            map.put("found", ipResourceService.queryIpExist(principal.getName(), ipResourceUpdateDto));
            resultDto.setData(map);
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    public ResultDto queryIpDetail(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(ipResourceService.queryIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/special/set", method = RequestMethod.PUT)
    public ResultDto setSpecialLine(Principal principal) {
        ResultDto resultDto = new ResultDto();
        try {
            ipResourceService.setSpecialLine();
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/releasedeleted", method = RequestMethod.PUT)
    public ResultDto deleteUseless(Principal principal) {
        ResultDto resultDto = new ResultDto();
        try {
            ipResourceService.releaseDeletedIp();
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/transferbindshops", method = RequestMethod.PUT)
    @PreAuthorize(Securitys.ADMIN_EL)
    public ResultDto transferBindShops(Principal principal) {
        ResultDto resultDto = new ResultDto();
        try {
            ipResourceService.transferBindShops();
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }
}
