package com.edgec.browserbackend.browser.dto;

import com.edgec.browserbackend.browser.domain.LoginHistory;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class LoginHistoryDto {
    private String account;
    private String nickname;
    private String loginIp;
    private String loginPlace;
    private String loginTime;

    public LoginHistoryDto(){

    }

    public LoginHistoryDto(LoginHistory loginHistory) {
        if (loginHistory.getUsername() != null)
            this.account = loginHistory.getUsername();
        if (loginHistory.getNickname() != null)
            this.nickname = loginHistory.getNickname();
        if (loginHistory.getLoginIp() != null)
            this.loginIp = loginHistory.getLoginIp();
        if (loginHistory.getLoginPlace() != null)
            this.loginPlace = loginHistory.getLoginPlace();
        if (loginHistory.getLoginTime() != 0)
            this.loginTime = Instant.ofEpochMilli(loginHistory.getLoginTime()).atZone(ZoneId.of("Asia/Shanghai")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getLoginPlace() {
        return loginPlace;
    }

    public void setLoginPlace(String loginPlace) {
        this.loginPlace = loginPlace;
    }

    public String getLoginIp() {
        return loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getLoginTime() {
        return loginTime;
    }

    public void setLoginTime(String loginTime) {
        this.loginTime = loginTime;
    }
}
