package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.UserShop;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface UserShopRepository extends MongoRepository<UserShop, String>, UserShopRepositoryCustom {
    List<UserShop> findByUsername(String username);
    UserShop findByUsernameAndShopId(String username, String shopId);
    List<UserShop> findByShopId(String shopId);
    List<UserShop> findByUsernameAndGroupId(String username, String groupId);
    List<UserShop> findByUsernameAndShopIdIn(String username, List<String> shopIds);
    int countByUsername(String username);
    int countByShopId(String shopId);
    int countByUsernameAndShopIdIn(String username, List<String> shopIds);
}
