package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.domain.Shop;
import com.google.gson.internal.$Gson$Preconditions;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface IpResourceRepository extends MongoRepository<IpResource, String>, IpResourceRepositoryCustom {
    IpResource findByAddr(String addr);
    IpResource findByAddrAndIsDeletedAndIsLocked(String addr, boolean isDeleted, boolean isLocked);
    IpResource findByAddrAndIsDeleted(String addr, boolean isDeleted);
    IpResource findByIdAndIsDeletedAndIsLocked(String id, boolean isDeleted, boolean isLocked);
    IpResource findByIdAndIsDeleted(String id, boolean isDeleted);
    List<IpResource> findByShopIdInAndIsDeleted(List<String> ipIds, boolean isDeleted);
    Page<IpResource> findByIdInAndIsDeletedOrderByPurchasedTimeDesc(List<String> ipIds, boolean isDeleted, Pageable pageable);
    List<IpResource> findByOwnerAndIsDeletedAndShopIdIsNull(String owner, boolean isDeleted);
    List<IpResource> findByOwnerAndStatusIsNotInAndIsDeletedAndShopIdIsNull(String owner, List<Integer> status, boolean isDeleted);
    List<IpResource> findByOwnerAndStatusAndIsDeletedAndShopIdIsNull(String owner, int status, boolean isDeleted);
    List<IpResource> findByStatusAndShopIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);
    Page<IpResource> findByAddrLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(String addr, List<String> ipIds, boolean isDeleted, Pageable pageable);
    Page<IpResource> findByVendorLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(String vendor, List<String> ipIds, boolean isDeleted, Pageable pageable);
    Page<IpResource> findByRegionCnLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(String region, List<String> ipIds, boolean isDeleted, Pageable pageable);
    List<IpResource> findByRegionCnLikeAndShopIdInAndIsDeleted(String regionCn, List<String> shopIds, boolean isDeleted);

    List<IpResource> findByStatusAndLockedAndLockTimestampLessThan(int status, boolean locked, long timestamp);

    List<IpResource> findByValidTimeBetweenAndIsDeleted(long beginTime, long endTime, boolean isDeleted);

    IpResource findByShopIdAndIsDeleted(String shopId, boolean isDeleted);

    int countByStatusAndIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);

    long countAllByIsDeleted(boolean isDeleted);

    long countAllByOwnerAndIsDeleted(String username, boolean isDeleted);
    long countAllByOwner(String username);
}
