//package com.edgec.browserbackend.common.commons.client;
//
//
//import org.apache.commons.lang3.StringUtils;
//import org.apache.http.HttpHost;
//import org.apache.http.client.CredentialsProvider;
//import org.elasticsearch.action.DocWriteResponse;
//import org.elasticsearch.action.index.IndexRequest;
//import org.elasticsearch.action.index.IndexResponse;
//import org.elasticsearch.client.RequestOptions;
//import org.elasticsearch.client.RestClient;
//import org.elasticsearch.client.RestHighLevelClient;
//import org.elasticsearch.common.xcontent.XContentType;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import java.io.IOException;
//
///**
// * Elasticsearch Rest Client
// * Make sure to config this client before use it
// * See example : intelligroup-tasks#com.edgec.intelligroup.config.ElasticsearchClientConfig
// */
//public class ElasticsearchClient {
//
//    private String hostname;
//    private int port;
//    private CredentialsProvider credentialsProvider;
//
//    private static final Logger log = LoggerFactory.getLogger(ElasticsearchClient.class);
//
//
//    public void index(String name, String id, String sourceJson) {
//        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(id) || StringUtils.isEmpty(sourceJson)) {
//            throw new IllegalArgumentException("Missing params");
//        }
//        RestHighLevelClient client = buildRestClient();
//        try {
//            IndexRequest indexRequest = new IndexRequest(name).id(id).source(sourceJson, XContentType.JSON);
//
//            IndexResponse indexResponse = client.index(indexRequest, RequestOptions.DEFAULT);
//            if (indexResponse != null && indexResponse.getResult() != null) {
//                if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
//                    log.info("Index created " + indexResponse.getId());
//                } else if (indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
//                    log.info("Index updated " + indexResponse.getId());
//                }
//            }
//        } catch (Exception e) {
//            log.error("Index request errors ", e);
//        } finally {
//            try {
//                client.close();
//            } catch (IOException e) {
//                log.error("Closing client errors ", e);
//            }
//        }
//    }
//
//    private RestHighLevelClient buildRestClient() {
//        RestHighLevelClient client = new RestHighLevelClient(
//                RestClient.builder(new HttpHost(hostname, port, "http"))
//                        .setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder).setHttpClientConfigCallback(httpAsyncClientBuilder -> httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider)));
//        return client;
//    }
//
//
//    public ElasticsearchClient(String hostname, int port, CredentialsProvider credentialsProvider) {
//        log.info("Initialize ElasticsearchClient host {} port {}", hostname, port);
//        this.hostname = hostname;
//        this.port = port;
//        this.credentialsProvider = credentialsProvider;
//    }
//}
