package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * 预订单
 */
@Document(collection = "preorder")
@JsonIgnoreProperties(ignoreUnknown = true)
public class PreOrder {
    //用户名
    private String userName;

    //时间
    private long time = System.currentTimeMillis();

    //金额
    private float amount;

    //订单号
    @Id
    private String tradeNo;

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public float getAmount() {
        return amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String toString() {
        return "PreOrder{" +
                "userName='" + userName + '\'' +
                ", time=" + time +
                ", amount=" + amount +
                ", tradeNo='" + tradeNo + '\'' +
                '}';
    }
}
